/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.commun.jaxb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public final class JAXBService
implements Serializable {
    private static final long serialVersionUID = 986110064372345330L;
    private static final JAXBService INSTANCE = new JAXBService();
    private Map<String, JAXBContext> contextMap = new ConcurrentHashMap<String, JAXBContext>();
    private Map<String, Queue<Unmarshaller>> unmarshallerMap = new ConcurrentHashMap<String, Queue<Unmarshaller>>();
    private Map<String, Queue<Marshaller>> marshallerMap = new ConcurrentHashMap<String, Queue<Marshaller>>();

    public static JAXBService instance() {
        return INSTANCE;
    }

    private JAXBService() {
    }

    private JAXBContext getContext(String contextPath) {
        JAXBContext context = this.contextMap.get(contextPath);
        if (context == null) {
            try {
                context = JAXBContext.newInstance((String)contextPath);
                this.contextMap.put(contextPath, context);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        return context;
    }

    private Marshaller getMarshaller(String contextPath, String encoding) {
        Marshaller marshaller;
        Queue<Marshaller> queue = this.marshallerMap.get(contextPath);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<Marshaller>();
            this.marshallerMap.put(contextPath, queue);
        }
        if ((marshaller = queue.poll()) == null) {
            marshaller = this.createMarshaller(contextPath, encoding);
        }
        return marshaller;
    }

    private Marshaller createMarshaller(String contextPath, String encoding) {
        JAXBContext context = this.getContext(contextPath);
        try {
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            return marshaller;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void retreiveMarshaller(String contextPath, Marshaller marshaller) {
        Queue<Marshaller> queue;
        if (marshaller != null && (queue = this.marshallerMap.get(contextPath)) != null) {
            queue.add(marshaller);
        }
    }

    private Unmarshaller getUnmarshaller(String contextPath) {
        Unmarshaller unmarshaller;
        Queue<Unmarshaller> queue = this.unmarshallerMap.get(contextPath);
        if (queue == null) {
            queue = new ConcurrentLinkedQueue<Unmarshaller>();
            this.unmarshallerMap.put(contextPath, queue);
        }
        if ((unmarshaller = queue.poll()) == null) {
            unmarshaller = this.createUnMarshaller(contextPath);
        }
        return unmarshaller;
    }

    private Unmarshaller createUnMarshaller(String contextPath) {
        JAXBContext context = this.getContext(contextPath);
        try {
            return context.createUnmarshaller();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void retreiveUnmarshaller(String contextPath, Unmarshaller unmarshaller) {
        Queue<Unmarshaller> queue;
        if (unmarshaller != null && (queue = this.unmarshallerMap.get(contextPath)) != null) {
            queue.add(unmarshaller);
        }
    }

    public Object getAsObject(String xmlAsString, String contextPath) {
        return this.getAsObject(xmlAsString, contextPath, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAsObject(String xmlAsString, String contextPath, String encoding) {
        Unmarshaller unmarshaller = this.getUnmarshaller(contextPath);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xmlAsString.getBytes(encoding));
            Object object = unmarshaller.unmarshal((InputStream)in);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            Object var6_8 = null;
            return var6_8;
        }
        finally {
            this.retreiveUnmarshaller(contextPath, unmarshaller);
        }
    }

    public String getAsString(Object object, String contextPath) {
        return this.getAsString(object, contextPath, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsString(Object object, String contextPath, String encoding) {
        Marshaller marshaller = this.getMarshaller(contextPath, encoding);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            marshaller.marshal(object, (OutputStream)out);
            String string = new String(out.toByteArray(), encoding);
            return string;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            this.retreiveMarshaller(contextPath, marshaller);
        }
    }
}

