/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.certificat;

import fr.atexo.json.reponse.verification.RetourVerification;
import fr.atexo.signature.commun.securite.certificat.InfosCertificat;
import fr.atexo.signature.commun.securite.certificat.InfosCrl;
import fr.atexo.signature.commun.securite.certificat.verification.CertificatValiditeEtat;
import fr.atexo.signature.commun.securite.certificat.verification.CertificatVerificationEtat;
import fr.atexo.signature.commun.securite.provider.bouncycastle.BouncyCaslteHandler;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.Provider;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatVerification {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificatVerification.class);
    private String cheminRepertoireTrust;
    private InfosCertificat infosCertificat;
    private InfosCertificat infosCertificatParent;
    private List<InfosCertificat> infosCertificats = new ArrayList<InfosCertificat>();
    private InfosCrl infosCrl;
    private List<InfosCrl> infosCrls = new ArrayList<InfosCrl>();
    private List<File> fichiersCrls = new ArrayList<File>();
    private Pattern patternNomRepertoire;

    public CertificatVerification(InfosCertificat infosCertificat) {
        this(infosCertificat, null, null);
    }

    public CertificatVerification(InfosCertificat infosCertificat, String cheminRepertoireTrust, Pattern patternNomRepertoire) {
        this.infosCertificat = infosCertificat;
        this.cheminRepertoireTrust = cheminRepertoireTrust;
        this.patternNomRepertoire = patternNomRepertoire;
    }

    public RetourVerification effectuerEnsembleVerifications() throws IOException {
        String nomRepertoire;
        LOGGER.info("Contr\u00f4le sur le certificat : " + this.infosCertificat.getCertificat().getSubjectX500Principal().toString());
        CertificatValiditeEtat codeRetourPeriodeValidite = this.verifierPeriodeDeValidite();
        LOGGER.info("Code retour pour la p\u00e9riode de validit\u00e9 : " + codeRetourPeriodeValidite);
        CertificatVerificationEtat codeRetourChaineDeCertification = this.verifierChaineDeCertification();
        LOGGER.info("Code retour pour la v\u00e9rification de la chaine de v\u00e9rification : " + codeRetourChaineDeCertification);
        CertificatVerificationEtat codeRetourRevocationCertificat = this.verifierRevocationCertificat();
        LOGGER.info("Code retour pour la r\u00e9vocation du certificat : " + codeRetourRevocationCertificat);
        RetourVerification retourVerification = new RetourVerification(codeRetourPeriodeValidite, codeRetourChaineDeCertification, codeRetourRevocationCertificat);
        for (InfosCertificat infosCertificat : this.infosCertificats) {
            if (infosCertificat.getFichierDisque() == null) continue;
            nomRepertoire = infosCertificat.getFichierDisque().getParentFile().getName();
            nomRepertoire = this.getNomRepertoire(nomRepertoire, this.patternNomRepertoire);
            retourVerification.ajouterRepertoireChaineCertification(nomRepertoire);
        }
        for (InfosCrl infosCrl : this.infosCrls) {
            if (infosCrl.getFichierDisque() == null) continue;
            nomRepertoire = infosCrl.getFichierDisque().getParentFile().getName();
            nomRepertoire = this.getNomRepertoire(nomRepertoire, this.patternNomRepertoire);
            retourVerification.ajouterRepertoireRevocation(nomRepertoire);
        }
        return retourVerification;
    }

    private String getNomRepertoire(String nomRepertoire, Pattern patternNomRepertoire) {
        Matcher matcher;
        String nomRepertoireModifie = nomRepertoire;
        if (patternNomRepertoire != null && (matcher = patternNomRepertoire.matcher(nomRepertoire)).find()) {
            try {
                nomRepertoireModifie = matcher.group(1);
            }
            catch (Exception e) {
                LOGGER.warn("Le r\u00e9pertoire " + nomRepertoire + " ne matche pas le pattern de la regex " + patternNomRepertoire.pattern());
            }
        }
        return nomRepertoireModifie;
    }

    public CertificatValiditeEtat verifierPeriodeDeValidite() {
        try {
            this.infosCertificat.getCertificat().checkValidity();
            return CertificatValiditeEtat.Valide;
        }
        catch (CertificateExpiredException e) {
            return CertificatValiditeEtat.Expire;
        }
        catch (CertificateNotYetValidException e) {
            return CertificatValiditeEtat.PasEncoreValide;
        }
    }

    public CertificatVerificationEtat verifierChaineDeCertification() {
        CertificatVerificationEtat verification = null;
        Provider provider = BouncyCaslteHandler.verifierPresenceEtRecupererProvider();
        IOFileFilter filtreRepertoire = DirectoryFileFilter.INSTANCE;
        if (this.cheminRepertoireTrust != null) {
            File repertoireRacine = new File(this.cheminRepertoireTrust);
            List<File> repertoires = Arrays.asList(repertoireRacine.listFiles(filtreRepertoire));
            Comparator<File> fileComparator = new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.compareTo(o2);
                }
            };
            Collections.sort(repertoires, fileComparator);
            for (File repertoire : repertoires) {
                verification = this.verifierChaineDeCertification(repertoire, provider);
                if (verification.getCodeRetour() != CertificatVerificationEtat.VerificationValide.getCodeRetour()) continue;
                return verification;
            }
        }
        return verification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertificatVerificationEtat verifierChaineDeCertification(File repertoireRacine, Provider provider) {
        CertificatVerificationEtat verificationEtatRacine;
        Collection<File> crts = FileUtils.listFiles(repertoireRacine, new String[]{"crt"}, true);
        Comparator<File> fileComparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.compareTo(o2);
            }
        };
        ArrayList<File> fichiersCrts = new ArrayList<File>(crts);
        Collections.sort(fichiersCrts, fileComparator);
        ArrayList<InfosCertificat> infosCertificats = new ArrayList<InfosCertificat>();
        for (File fichierCertificat : fichiersCrts) {
            FileInputStream inputStream;
            block18: {
                inputStream = null;
                try {
                    inputStream = new FileInputStream(fichierCertificat);
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X509", provider);
                    X509Certificate certificat = (X509Certificate)certificateFactory.generateCertificate(inputStream);
                    if (certificat == null) break block18;
                    InfosCertificat infosCertificat = new InfosCertificat(certificat, fichierCertificat);
                    infosCertificats.add(infosCertificat);
                }
                catch (Exception e) {
                    try {
                        LOGGER.error(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(inputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(inputStream);
                    continue;
                }
            }
            IOUtils.closeQuietly(inputStream);
        }
        InfosCertificat certificatEnTraitement = this.infosCertificat;
        while (certificatEnTraitement != null && !certificatEnTraitement.getCertificat().getSubjectX500Principal().getName().equals(certificatEnTraitement.getCertificat().getIssuerX500Principal().getName())) {
            InfosCertificat certificatParent = null;
            for (InfosCertificat infosCertificat : infosCertificats) {
                if (!infosCertificat.getCertificat().getSubjectX500Principal().getName().equals(certificatEnTraitement.getCertificat().getIssuerX500Principal().getName())) continue;
                try {
                    certificatEnTraitement.getCertificat().verify(infosCertificat.getCertificat().getPublicKey());
                }
                catch (SignatureException e) {
                    return CertificatVerificationEtat.SignatureCertificatInvalide;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!this.infosCertificats.contains(infosCertificat)) {
                    this.infosCertificats.add(infosCertificat);
                }
                certificatParent = infosCertificat;
            }
            certificatEnTraitement = certificatParent;
        }
        if (infosCertificats.isEmpty()) {
            return CertificatVerificationEtat.ChaineCertificatNonTrouvee;
        }
        if (certificatEnTraitement == null) {
            return CertificatVerificationEtat.ChaineCertificatIncomplete;
        }
        int tailleMinimun = this.infosCertificats.size() - 1;
        InfosCertificat infosCertificatRacine = this.infosCertificats.get(tailleMinimun);
        CertificatVerification certificationRacineVerification = new CertificatVerification(infosCertificatRacine);
        if (this.fichiersCrls.isEmpty()) {
            this.fichiersCrls.addAll(this.getFichiersCrls(repertoireRacine));
        }
        if ((verificationEtatRacine = certificationRacineVerification.verifierCertificatRacine(tailleMinimun)).getCodeRetour() != CertificatVerificationEtat.VerificationValide.getCodeRetour()) {
            return verificationEtatRacine;
        }
        this.infosCertificatParent = infosCertificatRacine;
        InfosCrl crlRacine = certificationRacineVerification.getInfosCrl();
        if (crlRacine != null && !this.infosCrls.contains(crlRacine)) {
            this.infosCrls.add(crlRacine);
        }
        for (int j = this.infosCertificats.size() - 2; j >= 0; --j) {
            InfosCertificat certificatParent;
            InfosCertificat certificatIntermediaire = this.infosCertificats.get(j);
            CertificatVerification certificatIntermediareVerification = new CertificatVerification(certificatIntermediaire);
            CertificatVerificationEtat verificationEtatIntermediaire = certificatIntermediareVerification.verifierCertificat(certificatParent = this.infosCertificats.get(j + 1), --tailleMinimun);
            if (verificationEtatIntermediaire.getCodeRetour() != CertificatVerificationEtat.VerificationValide.getCodeRetour()) {
                return verificationEtatIntermediaire;
            }
            this.infosCertificatParent = certificatParent;
            InfosCrl crlIntermediaire = certificatIntermediareVerification.getInfosCrl();
            if (crlIntermediaire == null || this.infosCrls.contains(crlIntermediaire)) continue;
            this.infosCrls.add(crlIntermediaire);
        }
        return CertificatVerificationEtat.VerificationValide;
    }

    private CertificatVerificationEtat verifierCertificatRacine(int tailleMinimun) {
        return this.verifierCertificat(this.infosCertificat, tailleMinimun);
    }

    private CertificatVerificationEtat verifierCertificat(InfosCertificat certificatParent, int tailleMinimun) {
        CertificatVerificationEtat verificationEtat = this.verifierSignatureCerticat(this.infosCertificat, certificatParent);
        if (verificationEtat.getCodeRetour() != CertificatVerificationEtat.VerificationValide.getCodeRetour()) {
            return verificationEtat;
        }
        CertificatValiditeEtat certificatValiditeEtat = this.verifierPeriodeDeValidite();
        if (certificatValiditeEtat != CertificatValiditeEtat.Valide) {
            return CertificatVerificationEtat.CertificatInvalide;
        }
        int taille = this.infosCertificat.getCertificat().getBasicConstraints();
        if (taille == -1) {
            return CertificatVerificationEtat.CertificatInvalide;
        }
        if (taille < tailleMinimun) {
            return CertificatVerificationEtat.CertificatInvalide;
        }
        return CertificatVerificationEtat.VerificationValide;
    }

    private CertificatVerificationEtat verifierSignatureCerticat(InfosCertificat certificat, InfosCertificat certificatParent) {
        try {
            certificat.getCertificat().verify(certificatParent.getCertificat().getPublicKey());
        }
        catch (Exception e) {
            return CertificatVerificationEtat.SignatureCertificatInvalide;
        }
        return CertificatVerificationEtat.VerificationValide;
    }

    private List<File> getFichiersCrls(File repertoireRacine) {
        Collection<File> crls = FileUtils.listFiles(repertoireRacine, new String[]{"crl"}, true);
        Comparator<File> fileComparator = new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.compareTo(o2);
            }
        };
        ArrayList<File> fichiersCrts = new ArrayList<File>(crls);
        Collections.sort(fichiersCrts, fileComparator);
        return fichiersCrts;
    }

    public CertificatVerificationEtat verifierRevocationCertificat() throws IOException {
        CertificatVerificationEtat certificatVerificationEtat = CertificatVerificationEtat.FichierCrlNonTrouve;
        if (!this.infosCertificats.isEmpty()) {
            String cheminRepertoire = this.infosCertificats.get(0).getFichierDisque().getParentFile().getAbsolutePath();
            certificatVerificationEtat = this.verifierRevocationCertificat(cheminRepertoire);
            return certificatVerificationEtat;
        }
        return certificatVerificationEtat;
    }

    public CertificatVerificationEtat verifierRevocationCertificat(String cheminRepertoire) throws IOException {
        File repertoireRacine = new File(cheminRepertoire);
        List<File> fichiersCrls = this.getFichiersCrls(repertoireRacine);
        for (File fichierCrl : fichiersCrls) {
            FileInputStream fichierCrlInputStream = new FileInputStream(fichierCrl);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fichierCrlInputStream);
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509CRL crl = (X509CRL)certificateFactory.generateCRL(bufferedInputStream);
                InfosCrl infosCrl = new InfosCrl(crl, fichierCrl);
                if (!crl.getIssuerX500Principal().getName().equals(this.infosCertificat.getCertificat().getIssuerX500Principal().getName())) continue;
                this.infosCrl = infosCrl;
            }
            catch (Exception e) {}
        }
        if (this.infosCrl != null) {
            boolean revocation = this.infosCrl.getCrl().isRevoked(this.infosCertificat.getCertificat());
            if (!revocation) {
                if (!this.infosCrls.contains(this.infosCrl)) {
                    this.infosCrls.add(this.infosCrl);
                }
                return CertificatVerificationEtat.VerificationValide;
            }
            if (!this.infosCrls.contains(this.infosCrl)) {
                this.infosCrls.add(this.infosCrl);
            }
            return CertificatVerificationEtat.CertificatRevoque;
        }
        return CertificatVerificationEtat.FichierCrlNonTrouve;
    }

    public List<File> getFichiersCrls() {
        return this.fichiersCrls;
    }

    public InfosCertificat getInfosCertificat() {
        return this.infosCertificat;
    }

    public InfosCertificat getInfosCertificatParent() {
        return this.infosCertificatParent;
    }

    public InfosCrl getInfosCrl() {
        return this.infosCrl;
    }

    public String getCheminRepertoireTrust() {
        return this.cheminRepertoireTrust;
    }

    public List<InfosCertificat> getInfosCertificats() {
        return this.infosCertificats;
    }

    public List<InfosCrl> getInfosCrls() {
        return this.infosCrls;
    }
}

