/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.chiffrement;

import fr.atexo.signature.commun.securite.chiffrement.ClefIV;
import fr.atexo.signature.commun.securite.chiffrement.InfosDechiffrement;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public abstract class AbstractChiffrement {
    private List<X509Certificate> certificats;
    private CBCBlockCipher cipherBlockChainingBlockCipher;
    private ParametersWithIV parametersWithIV;

    public AbstractChiffrement(List<X509Certificate> certificats, BlockCipher blockCipher, int tailleClef) {
        this.certificats = certificats;
        this.creerClefAlgorithm(blockCipher, tailleClef);
    }

    protected void creerClefAlgorithm(BlockCipher blockCipher, int tailleClef) {
        SecureRandom secureRandom = new SecureRandom();
        this.cipherBlockChainingBlockCipher = new CBCBlockCipher(blockCipher);
        byte[] bytes = new byte[tailleClef];
        byte[] iv = new byte[this.cipherBlockChainingBlockCipher.getBlockSize()];
        secureRandom.nextBytes(bytes);
        secureRandom.nextBytes(iv);
        this.parametersWithIV = new ParametersWithIV(new KeyParameter(bytes), iv);
    }

    public byte[] chiffrer(byte[] donnees) {
        int tailleBloc = this.cipherBlockChainingBlockCipher.getBlockSize();
        this.cipherBlockChainingBlockCipher.init(true, this.parametersWithIV);
        int nombreBlocs = donnees.length / tailleBloc + 1;
        byte[] plaintext = new byte[nombreBlocs * tailleBloc];
        System.arraycopy(donnees, 0, plaintext, 0, donnees.length);
        byte[] ciphertext = new byte[nombreBlocs * tailleBloc];
        for (int i = 0; i < ciphertext.length; i += tailleBloc) {
            this.cipherBlockChainingBlockCipher.processBlock(plaintext, i, ciphertext, i);
        }
        return ciphertext;
    }

    public byte[] dechiffrer(byte[] donnees, int taille, InfosDechiffrement infosDechiffrement) {
        PrivateKey privateKey = infosDechiffrement.getKeyPair().getPrivateKey();
        ParametersWithIV parametersWithIV = this.getClefDechiffrement(infosDechiffrement.getClefIV().getClef(), infosDechiffrement.getClefIV().getIv(), privateKey);
        this.cipherBlockChainingBlockCipher.init(false, parametersWithIV);
        byte[] plaintext = new byte[donnees.length];
        for (int i = 0; i < donnees.length; i += this.cipherBlockChainingBlockCipher.getBlockSize()) {
            this.cipherBlockChainingBlockCipher.processBlock(donnees, i, plaintext, i);
        }
        byte[] result = new byte[taille];
        System.arraycopy(plaintext, 0, result, 0, result.length);
        return result;
    }

    public List<ClefIV> getClefIVs() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        ArrayList<ClefIV> listKey = new ArrayList<ClefIV>();
        byte[] clef = ((KeyParameter)this.parametersWithIV.getParameters()).getKey();
        byte[] iv = this.parametersWithIV.getIV();
        Cipher cipher = Cipher.getInstance("RSA");
        for (int i = 0; i < this.certificats.size(); ++i) {
            X509Certificate certificate = this.certificats.get(i);
            PublicKey publicKey = certificate.getPublicKey();
            cipher.init(1, publicKey);
            ClefIV keyIv = new ClefIV(cipher.doFinal(clef), cipher.doFinal(iv), certificate);
            listKey.add(keyIv);
        }
        return listKey;
    }

    private ParametersWithIV getClefDechiffrement(byte[] cryptKey, byte[] cryptIv, PrivateKey privateKey) {
        try {
            Cipher decipher = Cipher.getInstance("RSA");
            decipher.init(2, privateKey);
            byte[] key = decipher.doFinal(cryptKey);
            byte[] iv = decipher.doFinal(cryptIv);
            return new ParametersWithIV(new KeyParameter(key), iv);
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        return null;
    }

    public List<X509Certificate> getCertificats() {
        return this.certificats;
    }

    public void setCertificats(List<X509Certificate> certificats) {
        this.certificats = certificats;
    }
}

