/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.provider;

import fr.atexo.signature.commun.exception.certificat.RecuperationCertificatException;
import fr.atexo.signature.commun.securite.provider.CertificatItem;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import fr.atexo.signature.commun.util.CertificatUtil;
import fr.atexo.signature.commun.util.Util;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractKeyStoreHandler {
    public static Provider recupererProvider(String nomProvider) {
        Provider provider = Security.getProvider(nomProvider);
        return provider;
    }

    public static Provider recupererProvider(TypeProvider typeProvider) {
        Provider provider = Security.getProvider(typeProvider.getNom());
        return provider;
    }

    public static KeyStore getKeyStore(TypeProvider typeProvider) throws RecuperationCertificatException {
        KeyStore keyStore = null;
        try {
            switch (typeProvider) {
                case MSCAPI: {
                    keyStore = KeyStore.getInstance(typeProvider.getType());
                    break;
                }
                case PKCS12: {
                    keyStore = KeyStore.getInstance(typeProvider.getType());
                    break;
                }
                case APPLE: {
                    keyStore = KeyStore.getInstance(typeProvider.getType(), typeProvider.getNom());
                }
            }
        }
        catch (Exception e) {
            throw new RecuperationCertificatException("Impossible d'acc\u00e8der au keysotre pour le provider " + (Object)((Object)typeProvider), e);
        }
        return keyStore;
    }

    protected List<CertificatItem> recupererCertificats(TypeProvider typeProvider, KeyStore keyStore, Set<String> hashCodes, boolean smartCard, boolean filtrerSignatureModeRGS, CertificatUtil.TypeCertificat ... typeCertificats) throws RecuperationCertificatException {
        if (hashCodes == null) {
            hashCodes = new HashSet<String>();
        }
        ArrayList<CertificatItem> listCertifItem = new ArrayList<CertificatItem>();
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                boolean filtrerRGS;
                String aliasKey = aliases.nextElement();
                boolean estClef = keyStore.isKeyEntry(aliasKey);
                if (!estClef) continue;
                X509Certificate certificat = (X509Certificate)keyStore.getCertificate(aliasKey);
                boolean signatureElectroniqueActif = true;
                boolean chiffrementActif = true;
                boolean authentificationActif = true;
                if (!filtrerSignatureModeRGS && typeCertificats != null && typeCertificats.length > 0) {
                    signatureElectroniqueActif = false;
                    chiffrementActif = false;
                    authentificationActif = false;
                    block8: for (CertificatUtil.TypeCertificat typeCertificat : typeCertificats) {
                        switch (typeCertificat) {
                            case SignatureElectronique: {
                                signatureElectroniqueActif = CertificatUtil.isUtilisablePourSignatureElectronique(certificat);
                                continue block8;
                            }
                            case Chiffrement: {
                                chiffrementActif = CertificatUtil.isUtilisablePourChiffrement(certificat);
                                continue block8;
                            }
                            case Authentification: {
                                authentificationActif = CertificatUtil.isUtilisablePourAuthentification(certificat);
                            }
                        }
                    }
                }
                boolean bl = filtrerRGS = filtrerSignatureModeRGS && !CertificatUtil.isUtilisablePourChiffrement(certificat) && CertificatUtil.isUtilisablePourSignatureElectronique(certificat);
                if (!filtrerRGS && (filtrerSignatureModeRGS || !signatureElectroniqueActif && !chiffrementActif && !authentificationActif)) continue;
                String sujetCn = CertificatUtil.getCN(certificat.getSubjectDN());
                String issuerCn = CertificatUtil.getCN(certificat.getIssuerDN());
                String dateValidation = Util.formaterDate(certificat.getNotAfter());
                String usage = CertificatUtil.getUtilisablePour(certificat);
                String hashCode = String.valueOf(certificat.hashCode());
                if (hashCodes.contains(hashCode)) continue;
                CertificatItem item = new CertificatItem(aliasKey, sujetCn, issuerCn, dateValidation, certificat.getNotAfter(), usage, smartCard, hashCode, TypeProvider.PKCS11);
                listCertifItem.add(item);
                hashCodes.add(hashCode);
            }
        }
        catch (KeyStoreException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration  des certificats se trouvant dans le key store du provider " + (Object)((Object)typeProvider), e);
        }
        return listCertifItem;
    }
}

