/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.provider.magasin;

import fr.atexo.signature.commun.exception.certificat.RecuperationCertificatException;
import fr.atexo.signature.commun.securite.certificat.KeyPair;
import fr.atexo.signature.commun.securite.provider.AbstractKeyStoreHandler;
import fr.atexo.signature.commun.securite.provider.CertificatItem;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import fr.atexo.signature.commun.util.CertificatUtil;
import fr.atexo.signature.logging.LogManager;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

public class MagasinHandler
extends AbstractKeyStoreHandler {
    private static MagasinHandler magasinHandler;

    public static MagasinHandler getInstance() {
        if (magasinHandler == null) {
            magasinHandler = new MagasinHandler();
        }
        return magasinHandler;
    }

    public List<CertificatItem> recupererCertificats(TypeProvider typeProvider, Set<String> hashCodes, boolean filtrerSignatureModeRGS, CertificatUtil.TypeCertificat ... typeCertificats) throws RecuperationCertificatException {
        KeyStore keyStore = this.getKeyStore(typeProvider, true);
        return super.recupererCertificats(typeProvider, keyStore, hashCodes, false, filtrerSignatureModeRGS, typeCertificats);
    }

    public KeyPair getKeyPair(TypeProvider typeProvider, String alias) throws RecuperationCertificatException {
        try {
            KeyStore keyStore = this.getKeyStore(typeProvider, true);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String aliasKey = aliases.nextElement();
                if (!aliasKey.equals(alias)) continue;
                X509Certificate certificat = (X509Certificate)keyStore.getCertificate(aliasKey);
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(aliasKey, typeProvider == TypeProvider.APPLE ? "convergence".toCharArray() : null);
                KeyPair keyPair = new KeyPair(certificat, privateKey, typeProvider);
                return keyPair;
            }
        }
        catch (KeyStoreException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration des alias se trouvant dans le key store du provider " + (Object)((Object)typeProvider), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration de la cl\u00e9 priv\u00e9e se trouvant dans le key store du provider " + (Object)((Object)typeProvider) + " pour l'alias " + alias, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration de la cl\u00e9 priv\u00e9e se trouvant dans le key store du provider " + (Object)((Object)typeProvider) + " pour l'alias " + alias, e);
        }
        return null;
    }

    public KeyPair getKeyPair(TypeProvider typeProvider, BigInteger serial, String emetteur) throws RecuperationCertificatException {
        try {
            KeyStore keyStore = this.getKeyStore(typeProvider, true);
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String aliasKey = aliases.nextElement();
                X509Certificate certificat = (X509Certificate)keyStore.getCertificate(aliasKey);
                BigInteger certificatSerial = certificat.getSerialNumber();
                String certificatEmetteur = ((Object)certificat.getIssuerDN()).toString();
                boolean serialsEgaux = certificatSerial.equals(serial);
                boolean emetteursEgaux = certificatEmetteur.equals(emetteur);
                LogManager.getInstance().afficherMessageInfo("Alias : " + aliasKey, this.getClass());
                LogManager.getInstance().afficherMessageInfo("Emetteur : " + certificatEmetteur + " => Emetteurs \u00e9gaux : " + emetteursEgaux, this.getClass());
                LogManager.getInstance().afficherMessageInfo("Serial : " + certificatSerial + " => Serials \u00e9gaux : " + serialsEgaux, this.getClass());
                if (!serialsEgaux || !emetteursEgaux) continue;
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(aliasKey, null);
                KeyPair keyPair = new KeyPair(certificat, privateKey, typeProvider);
                return keyPair;
            }
        }
        catch (Exception e) {
            throw new RecuperationCertificatException("Erreur de recup\u00e9ration du certificat personnel avec comme Serial " + serial + " et comme Issuer " + emetteur, e);
        }
        return null;
    }

    public KeyPair getKeyPair(KeyStore keyStore, TypeProvider typeProvider, BigInteger serial, String issuer) throws RecuperationCertificatException {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String aliasKey = aliases.nextElement();
                X509Certificate certificat = (X509Certificate)keyStore.getCertificate(aliasKey);
                if (!certificat.getSerialNumber().equals(serial) || !((Object)certificat.getIssuerDN()).toString().equals(issuer)) continue;
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(aliasKey, null);
                KeyPair keyPair = new KeyPair(certificat, privateKey, typeProvider);
                return keyPair;
            }
        }
        catch (Exception e) {
            throw new RecuperationCertificatException("Erreur de recup\u00e9ration du certificat personnel avec comme Serial " + serial + " et comme Issuer " + issuer, e);
        }
        return null;
    }

    public KeyStore getKeyStore(TypeProvider typeProvider, boolean reparerAlias) throws RecuperationCertificatException {
        try {
            KeyStore keyStore = MagasinHandler.getKeyStore(typeProvider);
            keyStore.load(null, null);
            if (reparerAlias) {
                this.reparerAlias(typeProvider, keyStore);
            }
            return keyStore;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RecuperationCertificatException("Erreur lors du chargement du key store du provider " + (Object)((Object)typeProvider), e);
        }
        catch (CertificateException e) {
            throw new RecuperationCertificatException("Erreur lors du chargement du key store du provider " + (Object)((Object)typeProvider), e);
        }
        catch (IOException e) {
            throw new RecuperationCertificatException("Erreur lors du chargement du key store du provider " + (Object)((Object)typeProvider), e);
        }
    }

    private void reparerAlias(TypeProvider typeProvider, KeyStore keyStore) {
        try {
            Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
            field.setAccessible(true);
            KeyStoreSpi keyStoreVeritable = (KeyStoreSpi)field.get(keyStore);
            if (typeProvider.getKeyStoreVeritable() != null && typeProvider.getKeyStoreVeritable().equals(keyStoreVeritable.getClass().getName())) {
                field = keyStoreVeritable.getClass().getEnclosingClass().getDeclaredField("entries");
                field.setAccessible(true);
                Collection entries = (Collection)field.get(keyStoreVeritable);
                for (Object entry : entries) {
                    field = entry.getClass().getDeclaredField("certChain");
                    field.setAccessible(true);
                    X509Certificate[] certificates = (X509Certificate[])field.get(entry);
                    if (certificates == null || certificates.length <= 0) continue;
                    String hashCode = Integer.toString(certificates[0].hashCode());
                    field = entry.getClass().getDeclaredField("alias");
                    field.setAccessible(true);
                    String alias = (String)field.get(entry);
                    if (alias.equals(hashCode)) continue;
                    field.set(entry, alias.concat(" - ").concat(hashCode));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

