/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.provider.multi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class MultiKeyStoreSpi
extends KeyStoreSpi {
    private final Map<String, KeyStore> keyStores;
    private final Set<String> aliases = new TreeSet<String>();

    public MultiKeyStoreSpi(Map<String, KeyStore> keyStores) {
        this.keyStores = keyStores;
    }

    @Override
    public final Enumeration<String> engineAliases() {
        return Collections.enumeration(this.aliases);
    }

    @Override
    public final boolean engineContainsAlias(String alias) {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        try {
            return this.keyStores.get(providerNameAndEntryAlias[0]).containsAlias(providerNameAndEntryAlias[1]);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public final void engineDeleteEntry(String alias) throws KeyStoreException {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        this.keyStores.get(providerNameAndEntryAlias[0]).deleteEntry(providerNameAndEntryAlias[1]);
        this.aliases.remove(alias);
    }

    @Override
    public final boolean engineEntryInstanceOf(String alias, Class<? extends KeyStore.Entry> entryClass) {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        try {
            return this.keyStores.get(providerNameAndEntryAlias[0]).entryInstanceOf(providerNameAndEntryAlias[1], entryClass);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public final Certificate engineGetCertificate(String alias) {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        try {
            return this.keyStores.get(providerNameAndEntryAlias[0]).getCertificate(providerNameAndEntryAlias[1]);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final String engineGetCertificateAlias(Certificate cert) {
        for (Map.Entry<String, KeyStore> entry : this.keyStores.entrySet()) {
            try {
                String entryAlias = entry.getValue().getCertificateAlias(cert);
                if (entryAlias == null) continue;
                return entry.getKey() + " - " + entryAlias;
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public final Certificate[] engineGetCertificateChain(String alias) {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        try {
            return this.keyStores.get(providerNameAndEntryAlias[0]).getCertificateChain(providerNameAndEntryAlias[1]);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final Date engineGetCreationDate(String alias) {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        try {
            return this.keyStores.get(providerNameAndEntryAlias[0]).getCreationDate(providerNameAndEntryAlias[1]);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final KeyStore.Entry engineGetEntry(String alias, KeyStore.ProtectionParameter protParam) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        return this.keyStores.get(providerNameAndEntryAlias[0]).getEntry(providerNameAndEntryAlias[1], protParam);
    }

    @Override
    public final Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        try {
            return this.keyStores.get(providerNameAndEntryAlias[0]).getKey(providerNameAndEntryAlias[1], password);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final boolean engineIsCertificateEntry(String alias) {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        try {
            return this.keyStores.get(providerNameAndEntryAlias[0]).isCertificateEntry(providerNameAndEntryAlias[1]);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public final boolean engineIsKeyEntry(String alias) {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        try {
            return this.keyStores.get(providerNameAndEntryAlias[0]).isKeyEntry(providerNameAndEntryAlias[1]);
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public final void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        for (KeyStore keyStore : this.keyStores.values()) {
            keyStore.load(stream, password);
        }
        for (Map.Entry entry : this.keyStores.entrySet()) {
            try {
                Enumeration<String> keyStoreAliases = ((KeyStore)entry.getValue()).aliases();
                while (keyStoreAliases.hasMoreElements()) {
                    this.aliases.add((String)entry.getKey() + " - " + keyStoreAliases.nextElement());
                }
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public final void engineLoad(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        for (KeyStore keyStore : this.keyStores.values()) {
            keyStore.load(param);
        }
        for (Map.Entry entry : this.keyStores.entrySet()) {
            try {
                Enumeration<String> keyStoreAliases = ((KeyStore)entry.getValue()).aliases();
                while (keyStoreAliases.hasMoreElements()) {
                    this.aliases.add((String)entry.getKey() + " - " + keyStoreAliases.nextElement());
                }
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public final void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        this.keyStores.get(providerNameAndEntryAlias[0]).setCertificateEntry(providerNameAndEntryAlias[1], cert);
        this.aliases.add(alias);
    }

    @Override
    public final void engineSetEntry(String alias, KeyStore.Entry entry, KeyStore.ProtectionParameter protParam) throws KeyStoreException {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        this.keyStores.get(providerNameAndEntryAlias[0]).setEntry(providerNameAndEntryAlias[1], entry, protParam);
        this.aliases.add(alias);
    }

    @Override
    public final void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        this.keyStores.get(providerNameAndEntryAlias[0]).setKeyEntry(providerNameAndEntryAlias[1], key, chain);
        this.aliases.add(alias);
    }

    @Override
    public final void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        this.keyStores.get(providerNameAndEntryAlias[0]).setKeyEntry(providerNameAndEntryAlias[1], key, password, chain);
        this.aliases.add(alias);
    }

    @Override
    public final int engineSize() {
        return this.aliases.size();
    }

    @Override
    public final void engineStore(KeyStore.LoadStoreParameter param) throws IOException, NoSuchAlgorithmException, CertificateException {
        for (KeyStore keyStore : this.keyStores.values()) {
            try {
                keyStore.store(param);
            }
            catch (KeyStoreException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public final void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        for (KeyStore keyStore : this.keyStores.values()) {
            try {
                keyStore.store(stream, password);
            }
            catch (KeyStoreException e) {
                throw new IOException(e);
            }
        }
    }

    public final String getProviderName(String alias) {
        String[] providerNameAndEntryAlias = alias.split(" - ", 2);
        KeyStore keyStore = this.keyStores.get(providerNameAndEntryAlias[0]);
        return keyStore != null ? keyStore.getProvider().getName() : null;
    }
}

