/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.provider.pkcs11;

import com.sun.security.auth.callback.DialogCallbackHandler;
import fr.atexo.signature.commun.exception.certificat.RecuperationCertificatException;
import fr.atexo.signature.commun.securite.certificat.KeyPair;
import fr.atexo.signature.commun.securite.provider.AbstractKeyStoreHandler;
import fr.atexo.signature.commun.securite.provider.CertificatItem;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import fr.atexo.signature.commun.securite.provider.multi.MultiKeyStore;
import fr.atexo.signature.commun.util.CertificatUtil;
import fr.atexo.signature.logging.LogManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AuthProvider;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import sun.security.pkcs11.SunPKCS11;

public class Pkcs11Handler
extends AbstractKeyStoreHandler {
    private static Pkcs11Handler pkcs11Handler;
    private MultiKeyStore keyStore;

    public static Pkcs11Handler getInstance() {
        if (pkcs11Handler == null) {
            pkcs11Handler = new Pkcs11Handler();
        }
        return pkcs11Handler;
    }

    public MultiKeyStore getKeyStore(Map<String, List<File>> providers) throws RecuperationCertificatException {
        TreeMap<String, KeyStore> keyStores = new TreeMap<String, KeyStore>();
        DialogCallbackHandler callbackHandler = new DialogCallbackHandler();
        block10: for (Map.Entry<String, List<File>> entry : providers.entrySet()) {
            String name = entry.getKey();
            for (File library : entry.getValue()) {
                SunPKCS11 provider;
                LogManager.getInstance().afficherMessageInfo("Recherche de la librairie : " + library.getAbsolutePath(), this.getClass());
                if (!library.exists()) continue;
                try {
                    provider = new SunPKCS11((InputStream)new ByteArrayInputStream(("name=" + name + "\n" + "library=" + library + "\n" + "attributes=compatibility").getBytes()));
                }
                catch (ProviderException e) {
                    continue;
                }
                ((AuthProvider)provider).setCallbackHandler((CallbackHandler)callbackHandler);
                AuthProvider ancienProvider = (AuthProvider)Security.getProvider(provider.getName());
                if (ancienProvider != null) {
                    LogManager.getInstance().afficherMessageInfo("Suppression du provider : " + ancienProvider.getName(), this.getClass());
                    try {
                        ancienProvider.logout();
                    }
                    catch (LoginException e) {
                        e.printStackTrace();
                    }
                    Security.removeProvider(ancienProvider.getName());
                }
                int numero = Security.addProvider(provider);
                LogManager.getInstance().afficherMessageInfo("Ajout du provider : " + provider.getName() + " en position : " + numero, this.getClass());
                try {
                    KeyStore keyStore = KeyStore.getInstance(TypeProvider.PKCS11.getType(), provider);
                    keyStores.put(name, keyStore);
                    continue block10;
                }
                catch (KeyStoreException e) {
                    e.printStackTrace();
                }
            }
        }
        MultiKeyStore keyStore = new MultiKeyStore(keyStores);
        try {
            keyStore.load(null, null);
            return keyStore;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RecuperationCertificatException("Erreur lors du chargement du key store du provider " + (Object)((Object)TypeProvider.PKCS11), e);
        }
        catch (CertificateException e) {
            throw new RecuperationCertificatException("Erreur lors du chargement du key store du provider " + (Object)((Object)TypeProvider.PKCS11), e);
        }
        catch (IOException e) {
            if (e.getCause() instanceof FailedLoginException) {
                throw new RecuperationCertificatException("Erreur lors du chargement du key store du provider  " + (Object)((Object)TypeProvider.PKCS11) + " car le pin est incorrect", e);
            }
            throw new RecuperationCertificatException("Erreur lors du chargement du key store du provider" + (Object)((Object)TypeProvider.PKCS11), e);
        }
    }

    public List<CertificatItem> recupererCertificats(Map<String, List<File>> providers, Set<String> hashCodes, boolean filtrerSignatureModeRGS, CertificatUtil.TypeCertificat ... typeCertificats) throws RecuperationCertificatException {
        this.keyStore = this.getKeyStore(providers);
        return super.recupererCertificats(TypeProvider.PKCS11, this.keyStore, hashCodes, true, filtrerSignatureModeRGS, typeCertificats);
    }

    public KeyPair getKeyPair(String alias) throws RecuperationCertificatException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String aliasKey = aliases.nextElement();
                if (!aliasKey.equals(alias)) continue;
                X509Certificate certificat = (X509Certificate)this.keyStore.getCertificate(aliasKey);
                PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(aliasKey, " ".toCharArray());
                String providerName = this.keyStore.getProviderName(aliasKey);
                KeyPair keyPair = new KeyPair(certificat, privateKey, TypeProvider.PKCS11, providerName);
                return keyPair;
            }
        }
        catch (KeyStoreException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration des alias se trouvant dans le key store du provider " + (Object)((Object)TypeProvider.PKCS11), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration de la cl\u00e9 priv\u00e9e se trouvant dans le key store du provider " + (Object)((Object)TypeProvider.PKCS11) + " pour l'alias " + alias, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration de la cl\u00e9 priv\u00e9e se trouvant dans le key store du provider " + (Object)((Object)TypeProvider.PKCS11) + " pour l'alias " + alias, e);
        }
        return null;
    }
}

