/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.provider.pkcs11.smartcard;

import fr.atexo.signature.commun.exception.certificat.RecuperationCertificatException;
import fr.atexo.signature.commun.securite.certificat.KeyPair;
import fr.atexo.signature.commun.securite.provider.CertificatItem;
import fr.atexo.signature.commun.securite.provider.TypeOs;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import fr.atexo.signature.commun.securite.provider.pkcs11.smartcard.SmartCardInformation;
import fr.atexo.signature.commun.util.CertificatUtil;
import fr.atexo.signature.commun.util.I18nUtil;
import fr.atexo.signature.commun.util.Util;
import fr.atexo.signature.commun.util.io.HashUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import sun.security.pkcs11.SunPKCS11;

public class SmartCardHandler {
    private static SmartCardHandler smartCardHandler;
    private TypeOs typeOs;
    private List<CardTerminal> cardTerminals;
    private int index;
    private CardTerminal cardTerminal;
    private Card card;
    private ATR atr;
    private String atrString;
    private List<SmartCardInformation> smartCardInformations;
    private File pkcs11Librairie;
    private SunPKCS11 sunPkcs11Provider;
    private KeyStore keyStore;

    public static SmartCardHandler getInstance() {
        if (smartCardHandler == null) {
            smartCardHandler = new SmartCardHandler();
        }
        return smartCardHandler;
    }

    public void initialiserDetection(TypeOs typeOs) {
        this.typeOs = typeOs;
        try {
            TerminalFactory factory = TerminalFactory.getDefault();
            this.cardTerminals = factory.terminals().list();
        }
        catch (CardException e) {
            e.printStackTrace();
        }
    }

    public void setSmartCardInformations(List<SmartCardInformation> smartCardInformations) {
        this.smartCardInformations = smartCardInformations;
    }

    public List<CardTerminal> getCardTerminals() {
        if (this.cardTerminals == null) {
            this.cardTerminals = new ArrayList<CardTerminal>();
        }
        return this.cardTerminals;
    }

    public int getNombreSmartCards() {
        return this.getCardTerminals().size();
    }

    public List<SmartCardInformation> getSmartCardInformations() {
        if (this.smartCardInformations == null) {
            this.smartCardInformations = new ArrayList<SmartCardInformation>();
        }
        return this.smartCardInformations;
    }

    private void connecter() throws CardException {
        System.out.println("Etablissement de la connexion \u00e0 la smart card " + this.getNomTerminalCard());
        this.card = this.cardTerminal.connect("*");
    }

    private void deconnecter() throws CardException {
        if (this.card != null) {
            System.out.println("Fermeture de la connexion \u00e0 la smart card " + this.getNomTerminalCard());
            this.card.disconnect(false);
        }
    }

    public boolean verifierCardTerminalSelectionnee() throws CardException {
        boolean smartCardPresente = false;
        smartCardPresente = this.typeOs == TypeOs.MacOs ? this.cardTerminal != null : this.cardTerminal != null && this.cardTerminal.isCardPresent();
        System.out.println("La smart card est-elle tjrs pr\u00e9sente et connect\u00e9 : " + smartCardPresente);
        return smartCardPresente;
    }

    public String getNomTerminalCard() {
        return this.cardTerminal.getName();
    }

    private void recupererATR() {
        this.atr = this.card.getATR();
        this.atrString = HashUtil.convertirBinaireEnHexadecimal(this.atr.getBytes());
    }

    public boolean selectionnerCardTerminal(int index) throws CardException {
        System.out.println("S\u00e9lection de la smart card ayant comme index :" + index);
        if (!this.cardTerminals.isEmpty()) {
            this.cardTerminal = this.cardTerminals.get(index);
            this.index = index;
            if (this.verifierCardTerminalSelectionnee()) {
                System.out.println("Smart card s\u00e9lectionn\u00e9e :" + this.getNomTerminalCard());
                return this.rechercherLibrairie();
            }
            System.out.println("Aucune Smart card n'est s\u00e9lectionn\u00e9e :" + this.getNomTerminalCard());
            this.pkcs11Librairie = null;
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rechercherLibrairie() throws CardException {
        System.out.println("Recherche de la librairie PKCS11 du fabriquant");
        if (this.typeOs != TypeOs.Indetermine && this.verifierCardTerminalSelectionnee() && !this.getSmartCardInformations().isEmpty()) {
            try {
                if (this.card == null) {
                    this.connecter();
                }
                this.recupererATR();
                System.out.println("Valeur de l'atr de la carte " + this.getNomTerminalCard() + " : " + this.atrString);
                boolean smartCardTrouvee = false;
                int i = 0;
                SmartCardInformation smartCardSelectionne = null;
                for (SmartCardInformation smartCardInformation : this.getSmartCardInformations()) {
                    System.out.println("Comparaison de l'atr avec ceux de la liste des smart cards enregistr\u00e9s :  " + smartCardInformation.getAtr());
                    char[] smartCardAtrTemp = smartCardInformation.getAtr().toCharArray();
                    if (this.atrString.length() == smartCardAtrTemp.length) {
                        String lettreSmartCardAtrTemp;
                        String lettreAtrString;
                        char c = "_".charAt(0);
                        for (i = 0; i < this.atrString.length() && ((lettreAtrString = Character.toString(this.atrString.charAt(i)).toUpperCase()).equals(lettreSmartCardAtrTemp = Character.toString(smartCardAtrTemp[i]).toUpperCase()) || smartCardAtrTemp[i] == c); ++i) {
                        }
                        if (i == this.atrString.length()) {
                            System.out.println("Smart card trouv\u00e9");
                            smartCardTrouvee = true;
                            smartCardSelectionne = smartCardInformation;
                            break;
                        }
                    }
                    i = 0;
                }
                if (smartCardTrouvee && smartCardSelectionne != null && smartCardSelectionne.getLibrairie() != null && smartCardSelectionne.getLibrairie().isFile()) {
                    System.out.println("Initialisation de la librairie PKCS11 avec la correspondance trouv\u00e9e");
                    this.pkcs11Librairie = smartCardSelectionne.getLibrairie();
                    System.out.println("Chemin vers la lib : " + this.pkcs11Librairie.getAbsolutePath());
                    smartCardTrouvee = this.pkcs11Librairie.isFile();
                } else {
                    smartCardTrouvee = false;
                }
                boolean bl = smartCardTrouvee;
                return bl;
            }
            finally {
                this.deconnecter();
            }
        }
        return false;
    }

    public List<CertificatItem> recupererCertificats(TypeProvider typeProvider, Set<String> hashs) throws RecuperationCertificatException {
        if (hashs == null) {
            hashs = new HashSet<String>();
        }
        ArrayList<CertificatItem> listCertifItem = new ArrayList<CertificatItem>();
        if (this.sunPkcs11Provider != null) {
            try {
                this.sunPkcs11Provider.logout();
            }
            catch (LoginException e) {
                e.printStackTrace();
            }
            catch (ProviderException e) {
                e.printStackTrace();
            }
            Security.removeProvider(this.sunPkcs11Provider.getName());
        }
        this.keyStore = null;
        String pkcs11Config = "name = SmartCard\nlibrary = " + this.pkcs11Librairie.getAbsolutePath() + "\nslotListIndex = " + this.index;
        System.out.println("Config PKCS11 : " + pkcs11Config);
        byte[] pkcs11ConfigBytes = pkcs11Config.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(pkcs11ConfigBytes);
        this.sunPkcs11Provider = new SunPKCS11((InputStream)bais);
        Security.addProvider(this.sunPkcs11Provider);
        System.out.println("Ajout du provider PKCS11");
        boolean effectuerAuthentification = true;
        KeyStore.CallbackHandlerProtection callbackHandlerProtection = new KeyStore.CallbackHandlerProtection(new PinPasswordCallbackHandler());
        KeyStore.Builder keystoreBuilder = null;
        while (true) {
            if (!effectuerAuthentification) {
                continue;
            }
            effectuerAuthentification = false;
            try {
                keystoreBuilder = KeyStore.Builder.newInstance(TypeProvider.PKCS11.getType(), this.sunPkcs11Provider, callbackHandlerProtection);
                this.keyStore = keystoreBuilder.getKeyStore();
            }
            catch (KeyStoreException e) {
                effectuerAuthentification = true;
                continue;
            }
            break;
        }
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String aliasKey = aliases.nextElement();
                X509Certificate certificat = (X509Certificate)this.keyStore.getCertificate(aliasKey);
                String usage = CertificatUtil.getUtilisablePour(certificat);
                if (usage == null) continue;
                String sujetCn = CertificatUtil.getCN(certificat.getSubjectDN());
                String issuerCn = CertificatUtil.getCN(certificat.getIssuerDN());
                String dateValidation = Util.formaterDate(certificat.getNotAfter());
                String hashCode = String.valueOf(certificat.hashCode());
                if (hashs.contains(hashCode)) continue;
                CertificatItem item = new CertificatItem(aliasKey, sujetCn, issuerCn, dateValidation, certificat.getNotAfter(), usage, true, hashCode, typeProvider);
                listCertifItem.add(item);
                hashs.add(hashCode);
            }
        }
        catch (KeyStoreException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration  des certificats se trouvant dans le key store du provider PKCS11", e);
        }
        return listCertifItem;
    }

    public KeyPair getKeyPair(String alias) throws RecuperationCertificatException {
        try {
            Enumeration<String> aliases = this.keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String aliasKey = aliases.nextElement();
                if (!aliasKey.equals(alias)) continue;
                X509Certificate certificat = (X509Certificate)this.keyStore.getCertificate(aliasKey);
                PrivateKey privateKey = (PrivateKey)this.keyStore.getKey(aliasKey, null);
                KeyPair keyPair = new KeyPair(certificat, privateKey, TypeProvider.PKCS11);
                return keyPair;
            }
        }
        catch (KeyStoreException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration des alias se trouvant dans le key store du provider " + (Object)((Object)TypeProvider.PKCS11), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration de la cl\u00e9 priv\u00e9e se trouvant dans le key store du provider " + (Object)((Object)TypeProvider.PKCS11) + " pour l'alias " + alias, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration de la cl\u00e9 priv\u00e9e se trouvant dans le key store du provider " + (Object)((Object)TypeProvider.PKCS11) + " pour l'alias " + alias, e);
        }
        return null;
    }

    public File getPkcs11Librairie() {
        return this.pkcs11Librairie;
    }

    private class PinPasswordCallbackHandler
    implements CallbackHandler {
        private PinPasswordCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(callbacks[i], "Callback non reconnu");
                }
                PasswordCallback passwordCallback = (PasswordCallback)callbacks[i];
                JPasswordField passwordField = new JPasswordField();
                JLabel label = new JLabel(I18nUtil.get("SWING_PKCS11_MOT_DE_PASSE"));
                JOptionPane.showConfirmDialog(null, new Object[]{label, passwordField}, I18nUtil.get("SWING_PKCS11_CODE_PIN") + " " + SmartCardHandler.this.getNomTerminalCard(), 2);
                passwordCallback.setPassword(new String(passwordField.getPassword()).toCharArray());
            }
        }
    }
}

