/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.provider.pkcs12;

import fr.atexo.signature.commun.exception.certificat.RecuperationCertificatException;
import fr.atexo.signature.commun.exception.certificat.RecuperationClePriveCertificatException;
import fr.atexo.signature.commun.securite.certificat.KeyPair;
import fr.atexo.signature.commun.securite.provider.AbstractKeyStoreHandler;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;

public class Pkcs12Handler
extends AbstractKeyStoreHandler {
    public static KeyPair getKeyPair(String cheminFichierP12, String motDePasse) throws RecuperationCertificatException {
        File fichierP12 = new File(cheminFichierP12);
        FileInputStream fichierP12InputStrean = null;
        try {
            if (fichierP12.exists()) {
                KeyPair keyPair;
                fichierP12InputStrean = new FileInputStream(fichierP12);
                KeyStore keyStore = Pkcs12Handler.getKeyStore(TypeProvider.PKCS12);
                keyStore.load(fichierP12InputStrean, motDePasse.toCharArray());
                RSAPrivateKey privateKey = (RSAPrivateKey)Pkcs12Handler.getPrivateKey(keyStore.aliases(), keyStore, motDePasse);
                X509Certificate certificat = Pkcs12Handler.getCertificate(privateKey.getModulus(), keyStore.aliases(), keyStore);
                KeyPair keyPair2 = keyPair = new KeyPair(certificat, privateKey, TypeProvider.PKCS12);
                return keyPair2;
            }
        }
        catch (CertificateException e) {
            throw new RecuperationCertificatException("Erreur lors du chargement dans le key store du fichier p12 : " + cheminFichierP12, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RecuperationCertificatException("Erreur lors du chargement dans le key store du fichier p12 " + cheminFichierP12, e);
        }
        catch (KeyStoreException e) {
            throw new RecuperationCertificatException("Erreur lors de la r\u00e9cup\u00e9ration des alias du fichier p12 " + cheminFichierP12, e);
        }
        catch (FileNotFoundException e) {
            throw new RecuperationCertificatException("Erreur lors de l'acc\u00e8s au fichier p12 " + cheminFichierP12, e);
        }
        catch (IOException e) {
            throw new RecuperationCertificatException("Erreur lors du chargement dans le key store du fichier p12 " + cheminFichierP12, e);
        }
        finally {
            try {
                fichierP12InputStrean.close();
            }
            catch (IOException e) {}
        }
        return null;
    }

    private static PrivateKey getPrivateKey(Enumeration<String> aliases, KeyStore keyStore, String motDePasse) throws RecuperationClePriveCertificatException {
        try {
            while (aliases.hasMoreElements()) {
                PrivateKey key;
                String alias = aliases.nextElement();
                if (alias == null || !keyStore.isKeyEntry(alias) || (key = (PrivateKey)keyStore.getKey(alias, motDePasse.toCharArray())) == null) continue;
                return key;
            }
        }
        catch (Exception e) {
            throw new RecuperationClePriveCertificatException("Impossible d'acc\u00e9der \u00e0 la cl\u00e9 priv\u00e9e", e);
        }
        return null;
    }

    private static X509Certificate getCertificate(BigInteger modulus, Enumeration<String> aliases, KeyStore keyStore) throws RecuperationCertificatException {
        try {
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate signingCertificate = (X509Certificate)keyStore.getCertificate(alias);
                if (!((RSAPublicKey)signingCertificate.getPublicKey()).getModulus().equals(modulus)) continue;
                return signingCertificate;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RecuperationCertificatException("Impossible de trouver le certificat", e);
        }
        return null;
    }
}

