/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.signature;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSignatureAppearance;
import com.itextpdf.text.pdf.PdfStamper;
import fr.atexo.signature.commun.securite.processor.signature.InfosComplementairesCertificat;
import fr.atexo.signature.commun.securite.processor.signature.InfosVerificationCertificat;
import fr.atexo.signature.commun.util.CertificatUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class SignaturePades {
    public static void signerFichierPdf(InputStream source, OutputStream destination, Certificate certificat, PrivateKey clefPrivee, Rectangle positionSignature, String texte) throws IOException, DocumentException {
        SignaturePades.signerFichierPdf(source, destination, certificat, clefPrivee, positionSignature, null, null, texte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signerFichierPdf(InputStream source, OutputStream destination, Certificate certificat, PrivateKey clefPrivee, Rectangle positionSignature, String raison, String lieu, String texte) throws IOException, DocumentException {
        try {
            PdfReader reader = new PdfReader(source);
            PdfStamper stamper = PdfStamper.createSignature(reader, destination, '\u0000', null, true);
            PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
            appearance.setCrypto(clefPrivee, new Certificate[]{certificat}, null, PdfSignatureAppearance.WINCER_SIGNED);
            appearance.setReason(raison);
            appearance.setLocation(lieu);
            if (texte != null) {
                Font font = new Font();
                font.setSize(8.0f);
                appearance.setLayer2Font(font);
                appearance.setLayer2Text(texte);
            }
            appearance.setAcro6Layers(false);
            appearance.setVisibleSignature(positionSignature, reader.getNumberOfPages(), null);
            stamper.setFullCompression();
            stamper.close();
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    public static List<InfosComplementairesCertificat> verifier(byte[] contenuFichierPdfSigne) throws IOException, SignatureException {
        PdfReader reader = new PdfReader(contenuFichierPdfSigne);
        return SignaturePades.verifier(reader);
    }

    public static List<InfosComplementairesCertificat> verifier(File fichierPdfSigne) throws IOException, SignatureException {
        PdfReader reader = new PdfReader(fichierPdfSigne.getAbsolutePath());
        return SignaturePades.verifier(reader);
    }

    private static List<InfosComplementairesCertificat> verifier(PdfReader reader) throws IOException, SignatureException {
        ArrayList<InfosComplementairesCertificat> infosComplementairesCertificats = new ArrayList<InfosComplementairesCertificat>();
        AcroFields acroFields = reader.getAcroFields();
        ArrayList<String> names = acroFields.getSignatureNames();
        if (names.size() != 0) {
            for (int k = 0; k < names.size(); ++k) {
                String name = names.get(k);
                PdfPKCS7 pdfPKCS7 = acroFields.verifySignature(name);
                InfosComplementairesCertificat infosVerificationCertificat = CertificatUtil.extraireInformations(pdfPKCS7.getSigningCertificate(), new InfosVerificationCertificat());
                infosVerificationCertificat.setSignatureValide(pdfPKCS7.verify());
                infosComplementairesCertificats.add(infosVerificationCertificat);
            }
        }
        return infosComplementairesCertificats;
    }

    public static List<X509Certificate> extraireCertificats(File fichierPdfSigne) throws IOException {
        PdfReader reader = new PdfReader(fichierPdfSigne.getAbsolutePath());
        return SignaturePades.extraireCertificats(reader);
    }

    public static List<X509Certificate> extraireCertificats(byte[] contenuFichierPdfSigne) throws IOException {
        PdfReader reader = new PdfReader(contenuFichierPdfSigne);
        return SignaturePades.extraireCertificats(reader);
    }

    private static List<X509Certificate> extraireCertificats(PdfReader reader) throws IOException {
        ArrayList<X509Certificate> certificats = new ArrayList<X509Certificate>();
        AcroFields acroFields = reader.getAcroFields();
        ArrayList<String> names = acroFields.getSignatureNames();
        if (names.size() != 0) {
            for (int k = 0; k < names.size(); ++k) {
                String name = names.get(k);
                PdfPKCS7 pdfPKCS7 = acroFields.verifySignature(name);
                certificats.add(pdfPKCS7.getSigningCertificate());
            }
        }
        return certificats;
    }
}

