/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.signature;

import fr.atexo.signature.commun.securite.certificat.KeyPair;
import fr.atexo.signature.commun.securite.processor.signature.InfosComplementairesCertificat;
import fr.atexo.signature.commun.securite.processor.signature.InfosVerificationCertificat;
import fr.atexo.signature.commun.securite.provider.AbstractKeyStoreHandler;
import fr.atexo.signature.commun.securite.provider.bouncycastle.BouncyCaslteHandler;
import fr.atexo.signature.commun.securite.signature.TypeAlgorithmHash;
import fr.atexo.signature.commun.util.CertificatUtil;
import fr.atexo.signature.commun.util.io.HashUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.iharder.Base64;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class SignaturePkcs7 {
    public static byte[] signer(KeyPair keyPair, TypeAlgorithmHash typeAlgorithmHash, byte[] donnees, boolean detachee) throws Exception {
        Provider providerCertStore = null;
        Provider providerSignature = null;
        switch (keyPair.getProvider()) {
            case MSCAPI: 
            case APPLE: 
            case PKCS11: {
                providerSignature = AbstractKeyStoreHandler.recupererProvider(keyPair.getNomProvider());
                providerCertStore = BouncyCaslteHandler.verifierPresenceEtRecupererProvider();
                break;
            }
            default: {
                providerSignature = providerCertStore = BouncyCaslteHandler.verifierPresenceEtRecupererProvider();
            }
        }
        CMSProcessableByteArray typedData = new CMSProcessableByteArray(donnees);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(keyPair.getCertificate());
        JcaCertStore certs = new JcaCertStore(certList);
        JcaContentSignerBuilder contentSignerBuilder = new JcaContentSignerBuilder(typeAlgorithmHash.getSignatureAlgorithm()).setProvider(providerSignature);
        ContentSigner sha1Signer = contentSignerBuilder.build(keyPair.getPrivateKey());
        JcaDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder();
        digestCalculatorProviderBuilder.setProvider(providerCertStore);
        DigestCalculatorProvider digestCalculatorProvider = digestCalculatorProviderBuilder.build();
        JcaSignerInfoGeneratorBuilder signerInfoGeneratorBuilder = new JcaSignerInfoGeneratorBuilder(digestCalculatorProvider);
        SignerInfoGenerator signerInfoGenerator = signerInfoGeneratorBuilder.build(sha1Signer, keyPair.getCertificate());
        CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
        signedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
        signedDataGenerator.addCertificates(certs);
        CMSSignedData signedData = signedDataGenerator.generate(typedData, detachee);
        return signedData.getEncoded();
    }

    public static byte[] signerHash(KeyPair keyPair, TypeAlgorithmHash typeAlgorithmHash, String hash) throws Exception {
        byte[] hashEnByte = HashUtil.convertirHexadecimalEnBinaire(hash);
        return SignaturePkcs7.signer(keyPair, typeAlgorithmHash, hashEnByte, true);
    }

    public static InfosComplementairesCertificat verifierHash(File fichier, String contenuFichierSignatureEnBase64, TypeAlgorithmHash typeAlgorithmHash) throws IOException {
        InfosComplementairesCertificat infosComplementairesCertificat = null;
        String hashFichier = HashUtil.genererHashShaHexadecimal(typeAlgorithmHash, fichier);
        byte[] hashEnByte = HashUtil.convertirHexadecimalEnBinaire(hashFichier);
        try {
            Provider provider = BouncyCaslteHandler.verifierPresenceEtRecupererProvider();
            byte[] contenuFichierSignature = Base64.decode(contenuFichierSignatureEnBase64);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contenuFichierSignature);
            ASN1InputStream asn1InputStream = new ASN1InputStream(byteArrayInputStream);
            byteArrayInputStream.close();
            CMSProcessableByteArray contentToSign = new CMSProcessableByteArray(hashEnByte);
            CMSSignedData verifData = new CMSSignedData((CMSProcessable)contentToSign, ContentInfo.getInstance(asn1InputStream.readObject()));
            asn1InputStream.close();
            CertStore certValidationStore = verifData.getCertificatesAndCRLs("Collection", provider.getName());
            SignerInformationStore signerInfoStore = verifData.getSignerInfos();
            Collection collec = signerInfoStore.getSigners();
            for (SignerInformation signerInformation : collec) {
                Collection<? extends Certificate> certificates = certValidationStore.getCertificates(signerInformation.getSID());
                Iterator<? extends Certificate> iterator = certificates.iterator();
                X509Certificate x509Certificat = (X509Certificate)iterator.next();
                if (x509Certificat.getBasicConstraints() != -1) continue;
                infosComplementairesCertificat = CertificatUtil.extraireInformations(x509Certificat, new InfosVerificationCertificat());
                if (signerInformation.verify(x509Certificat, provider.getName())) {
                    infosComplementairesCertificat.setSignatureValide(true);
                    continue;
                }
                infosComplementairesCertificat.setSignatureValide(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return infosComplementairesCertificat;
    }
}

