/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.signature;

import fr.atexo.signature.commun.securite.certificat.InfosCertificat;
import fr.atexo.signature.commun.securite.certificat.InfosCrl;
import fr.atexo.signature.commun.securite.certificat.KeyPair;
import fr.atexo.signature.commun.securite.processor.signature.InfosVerificationCertificat;
import fr.atexo.signature.commun.securite.signature.TagNameURIDereferencer;
import fr.atexo.signature.commun.securite.signature.TypeAlgorithmHash;
import fr.atexo.signature.commun.securite.signature.X509KeySelector;
import fr.atexo.signature.commun.util.CertificatUtil;
import fr.atexo.signature.commun.util.Util;
import fr.atexo.signature.commun.util.io.HashUtil;
import fr.atexo.signature.commun.util.io.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.iharder.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SignatureXades {
    private static final String PROPRIETE_PROVIDER = "org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static final String PROPRIETE_VALIDATION_XML_JDK7 = "org.apache.jcp.xml.dsig.secureValidation";
    private static final String URI_CONSTANTE = "http://atexo.com/#signedProps";
    private static final List<String> HASHS_CONSTANTE_URI_ATEXO = Arrays.asList("nwA9oxgmt3PO38tK6863KUeLmSA=", "n3djJyN7zMjXV+fSBz5xi/pt7cs=", "XP14ZMFwHebPywzRs82sAOBGrvs+FCFTseHyxj0q4EM=");
    private static final String HASH_CONSTANTE_URI_ATEXO_NOUVEAU = "WIXo3AkjNPd7MtQNOnwEEI/DLF8=";

    public static String signer(KeyPair keyPair, byte[] hashBinaireFichier, URI uriFichier, Date dateSignature, TypeAlgorithmHash typeAlgorithmHash) throws Exception {
        String idSignature = "signature";
        String providerName = System.getProperty("jsr105Provider", PROPRIETE_PROVIDER);
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        DigestMethod digestMethod = xmlSignatureFactory.newDigestMethod(typeAlgorithmHash.getAlgoDigestMethod(), null);
        Transform transform = xmlSignatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null);
        String uriFichierComplet = null;
        if (uriFichier != null) {
            uriFichierComplet = uriFichier.toASCIIString();
        }
        Reference referenceSignedFile = xmlSignatureFactory.newReference(uriFichierComplet, digestMethod, Collections.singletonList(transform), null, null, hashBinaireFichier);
        String referenceURI = "xmldsig-" + UUID.randomUUID() + "-" + "signedProps";
        String type = typeAlgorithmHash.getNameSpace() + "#SignedProperties";
        Reference referenceSignedProperties = xmlSignatureFactory.newReference("#" + referenceURI, digestMethod, Collections.singletonList(transform), type, null);
        ArrayList<Reference> referencesList = new ArrayList<Reference>();
        referencesList.add(referenceSignedFile);
        referencesList.add(referenceSignedProperties);
        CanonicalizationMethod canonicalizationMethod = xmlSignatureFactory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        SignatureMethod signatureMethod = xmlSignatureFactory.newSignatureMethod(typeAlgorithmHash.getAlgoSignatureMethod(), null);
        SignedInfo signedInfo = xmlSignatureFactory.newSignedInfo(canonicalizationMethod, signatureMethod, referencesList, "signedInfos");
        X509Certificate x509Certificate = keyPair.getCertificate();
        KeyInfoFactory keyInfoFactory = xmlSignatureFactory.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        x509Content.add(x509Certificate.getSubjectX500Principal().getName("RFC1779"));
        x509Content.add(x509Certificate);
        X509Data x509Data = keyInfoFactory.newX509Data(x509Content);
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        ArrayList<XMLObject> liste = new ArrayList<XMLObject>();
        Element qualifyingProperties = SignatureXades.creerElementQualifyingProperties(document, typeAlgorithmHash, "#" + idSignature);
        Element elementSignedProperties = SignatureXades.creerElementSignedProperties(document, dateSignature, referenceURI, x509Certificate, typeAlgorithmHash);
        qualifyingProperties.appendChild(elementSignedProperties);
        XMLObject object = xmlSignatureFactory.newXMLObject(Collections.singletonList(new DOMStructure(qualifyingProperties)), "object", null, null);
        liste.add(object);
        XMLSignature signature = xmlSignatureFactory.newXMLSignature(signedInfo, keyInfo, liste, idSignature, null);
        DOMSignContext domSignContext = new DOMSignContext(keyPair.getPrivateKey(), (Node)document);
        domSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
        domSignContext.putNamespacePrefix(typeAlgorithmHash.getNameSpaceVersionXades(), "xades");
        domSignContext.setURIDereferencer(new TagNameURIDereferencer(document, "xades", "SignedProperties"));
        domSignContext.setProperty(PROPRIETE_VALIDATION_XML_JDK7, false);
        signature.sign(domSignContext);
        String contenuFichierSignatureXML = XMLUtil.convertir(document, "UTF-8");
        return contenuFichierSignatureXML;
    }

    public static X509Certificate extraireCertificat(String contenuSignatureXML) throws ClassNotFoundException, IllegalAccessException, InstantiationException, ParserConfigurationException, IOException, SAXException, MarshalException {
        String providerName = System.getProperty("jsr105Provider", PROPRIETE_PROVIDER);
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        InputSource inputSourceSignatureXML = new InputSource(new StringReader(contenuSignatureXML));
        Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSourceSignatureXML);
        NodeList listeSignatures = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (listeSignatures.getLength() > 0) {
            DOMValidateContext validateContext = new DOMValidateContext(new X509KeySelector(), listeSignatures.item(0));
            XMLSignature signature = xmlSignatureFactory.unmarshalXMLSignature(validateContext);
            KeyInfo keyInfo = signature.getKeyInfo();
            X509Data data = (X509Data)keyInfo.getContent().get(0);
            X509Certificate certificate = (X509Certificate)data.getContent().get(1);
            return certificate;
        }
        return null;
    }

    public static InfosVerificationCertificat verifier(String contenuSignatureXML, File fichier) throws Exception {
        ArrayList<String> hashFichiers = new ArrayList<String>();
        String hashSha1Fichier = HashUtil.genererHashSha1Hexadecimal(fichier);
        hashFichiers.add(hashSha1Fichier);
        String hashSha256Fichier = HashUtil.genererHashSha256Hexadecimal(fichier);
        hashFichiers.add(hashSha256Fichier);
        return SignatureXades.verifier(contenuSignatureXML, hashFichiers);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static InfosVerificationCertificat verifier(String contenuSignatureXML, List<String> hashFichiers) throws Exception {
        String providerName = System.getProperty("jsr105Provider", PROPRIETE_PROVIDER);
        XMLSignatureFactory xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(providerName).newInstance());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        InputSource inputSourceSignatureXML = new InputSource(new StringReader(contenuSignatureXML));
        Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSourceSignatureXML);
        NodeList listeSignatures = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        InfosVerificationCertificat infosVerificationCertificat = new InfosVerificationCertificat();
        if (listeSignatures.getLength() <= 0) {
            infosVerificationCertificat.setEtat(2);
            infosVerificationCertificat.setSignatureValide(false);
            return infosVerificationCertificat;
        }
        DOMValidateContext validateContext = new DOMValidateContext(new X509KeySelector(), listeSignatures.item(0));
        XMLSignature signature = xmlSignatureFactory.unmarshalXMLSignature(validateContext);
        KeyInfo keyInfo = signature.getKeyInfo();
        X509Data data = (X509Data)keyInfo.getContent().get(0);
        X509Certificate certificate = (X509Certificate)data.getContent().get(1);
        infosVerificationCertificat = (InfosVerificationCertificat)CertificatUtil.extraireInformations(certificate, new InfosVerificationCertificat());
        PublicKey publicKey = certificate.getPublicKey();
        validateContext = new DOMValidateContext(publicKey, listeSignatures.item(0));
        validateContext.setProperty(PROPRIETE_VALIDATION_XML_JDK7, false);
        boolean validationOk = signature.getSignatureValue().validate(validateContext);
        if (!validationOk) {
            infosVerificationCertificat.setEtat(2);
            infosVerificationCertificat.setSignatureValide(false);
            return infosVerificationCertificat;
        }
        Iterator referenceIterator = signature.getSignedInfo().getReferences().iterator();
        int j = 0;
        while (true) {
            if (!referenceIterator.hasNext()) {
                infosVerificationCertificat.setEtat(0);
                infosVerificationCertificat.setSignatureValide(true);
                return infosVerificationCertificat;
            }
            Reference reference = (Reference)referenceIterator.next();
            if (j == 0) {
                byte[] digestValue = reference.getDigestValue();
                String digestValueHexadecimal = null;
                digestValueHexadecimal = digestValue.length == 20 || digestValue.length == 32 ? HashUtil.convertirBinaireEnHexadecimal(digestValue) : new String(digestValue);
                boolean hashOk = false;
                for (String hashFichier : hashFichiers) {
                    if (!hashFichier.equals(digestValueHexadecimal)) continue;
                    hashOk = true;
                    break;
                }
                if (!hashOk) {
                    infosVerificationCertificat.setEtat(5);
                    infosVerificationCertificat.setSignatureValide(false);
                    return infosVerificationCertificat;
                }
            } else if (j == 1) {
                String referenceDigestValue = Base64.encodeBytes(reference.getDigestValue());
                if (!URI_CONSTANTE.equals(reference.getURI()) || !HASHS_CONSTANTE_URI_ATEXO.contains(referenceDigestValue)) {
                    boolean refValid;
                    if (!URI_CONSTANTE.equals(reference.getURI())) {
                        validateContext.setURIDereferencer(new TagNameURIDereferencer(document, "xades", "SignedProperties"));
                    }
                    if (!(refValid = reference.validate(validateContext))) {
                        infosVerificationCertificat.setEtat(6);
                        infosVerificationCertificat.setSignatureValide(false);
                        return infosVerificationCertificat;
                    }
                }
            }
            ++j;
        }
    }

    public static String ajouterUnsignedProperties(String signatureXML, List<InfosCertificat> certificatRefs, List<InfosCrl> crlRevocationRefs, TypeAlgorithmHash typeAlgorithmHash) throws Exception {
        if (!certificatRefs.isEmpty() || !crlRevocationRefs.isEmpty()) {
            InputSource inputSource = new InputSource(new StringReader(signatureXML));
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            NodeList nodeList = document.getElementsByTagName("xades:QualifyingProperties");
            Element unsignedProperties = SignatureXades.creerElementUnsignedProperties(document, certificatRefs, crlRevocationRefs, typeAlgorithmHash);
            nodeList.item(0).appendChild(unsignedProperties);
            String contenuFichierSignatureXML = XMLUtil.convertir(document, "UTF-8");
            return contenuFichierSignatureXML;
        }
        return signatureXML;
    }

    private static Element creerElementQualifyingProperties(Document document, TypeAlgorithmHash typeAlgorithmHash, String cible) {
        Element qualifyingProperties = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "QualifyingProperties");
        qualifyingProperties.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xades", typeAlgorithmHash.getNameSpaceVersionXades());
        qualifyingProperties.setAttributeNS(null, "Target", cible);
        qualifyingProperties.setPrefix("xades");
        return qualifyingProperties;
    }

    private static Element creerElementSignedProperties(Document document, Date dateSignature, String referenceURI, X509Certificate certificate, TypeAlgorithmHash typeAlgorithmHash) throws ParserConfigurationException, CertificateEncodingException, NoSuchAlgorithmException {
        Element signedProperties = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "SignedProperties");
        signedProperties.setPrefix("xades");
        signedProperties.setAttributeNS(null, "Id", referenceURI);
        Element signedSignatureProperties = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "SignedSignatureProperties");
        signedSignatureProperties.setPrefix("xades");
        signedProperties.appendChild(signedSignatureProperties);
        Element signingTime = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "SigningTime");
        signingTime.setPrefix("xades");
        signedSignatureProperties.appendChild(signingTime);
        String dateSignatureISO8601 = Util.creerISO8601DateTime(dateSignature);
        Text textSigningTime = document.createTextNode(dateSignatureISO8601);
        signingTime.appendChild(textSigningTime);
        Element signingCertificate = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "SigningCertificate");
        signingCertificate.setPrefix("xades");
        signedSignatureProperties.appendChild(signingCertificate);
        Element cert = SignatureXades.creerElementCert(document, "xades", "http://www.w3.org/2000/09/xmldsig#", "ds", certificate, typeAlgorithmHash);
        signingCertificate.appendChild(cert);
        return signedProperties;
    }

    private static Element creerElementUnsignedProperties(Document document, List<InfosCertificat> certificatRefs, List<InfosCrl> crlRevocationRefs, TypeAlgorithmHash typeAlgorithmHash) throws CertificateEncodingException, CRLException {
        Element cert;
        Element unsignedProperties = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "UnsignedProperties");
        unsignedProperties.setPrefix("xades");
        Element unsignedSignatureProperties = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "UnsignedSignatureProperties");
        unsignedSignatureProperties.setPrefix("xades");
        unsignedProperties.appendChild(unsignedSignatureProperties);
        if (!certificatRefs.isEmpty()) {
            Element completeCertificateRefs = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "CompleteCertificateRefs");
            completeCertificateRefs.setPrefix("xades");
            unsignedSignatureProperties.appendChild(completeCertificateRefs);
            Element certRefs = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "CertRefs");
            certRefs.setPrefix("xades");
            completeCertificateRefs.appendChild(certRefs);
            for (InfosCertificat infosCertificat : certificatRefs) {
                cert = SignatureXades.creerElementCert(document, "xades", "http://www.w3.org/2000/09/xmldsig#", "ds", infosCertificat.getCertificat(), typeAlgorithmHash);
                certRefs.appendChild(cert);
            }
        }
        if (!crlRevocationRefs.isEmpty()) {
            Element completeRevocationRefs = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "CompleteRevocationRefs");
            completeRevocationRefs.setPrefix("xades");
            unsignedSignatureProperties.appendChild(completeRevocationRefs);
            Element crlRefs = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "CRLRefs");
            crlRefs.setPrefix("xades");
            completeRevocationRefs.appendChild(crlRefs);
            for (InfosCrl infosCrl : crlRevocationRefs) {
                cert = SignatureXades.creerElementCRLRef(document, "xades", "http://www.w3.org/2000/09/xmldsig#", "ds", infosCrl.getCrl(), typeAlgorithmHash);
                crlRefs.appendChild(cert);
            }
        }
        return unsignedProperties;
    }

    private static Element creerElementIssuerSerial(Document document, String nameSpaceXades, String prefixXades, String nameSpaceDsig, String prefixDsig, X509Certificate certificate) {
        Element issuerSerial = document.createElementNS(nameSpaceXades, "IssuerSerial");
        issuerSerial.setPrefix(prefixXades);
        Element x509IssuerName = document.createElementNS(nameSpaceDsig, "X509IssuerName");
        x509IssuerName.setPrefix(prefixDsig);
        issuerSerial.appendChild(x509IssuerName);
        Text textX509IssuerName = document.createTextNode(certificate.getIssuerX500Principal().getName("RFC1779"));
        x509IssuerName.appendChild(textX509IssuerName);
        Element x509SerialNumber = document.createElementNS(nameSpaceDsig, "X509SerialNumber");
        x509SerialNumber.setPrefix(prefixDsig);
        issuerSerial.appendChild(x509SerialNumber);
        Text textX509SerialNumber = document.createTextNode(String.valueOf(certificate.getSerialNumber()));
        x509SerialNumber.appendChild(textX509SerialNumber);
        return issuerSerial;
    }

    private static Element creerElementDigest(Document document, String nameSpaceXades, String prefixXades, String nameSpaceDsig, String prefixDsig, String nomElement, byte[] infosEncodes, TypeAlgorithmHash typeAlgorithmHash) {
        Element digestElement = document.createElementNS(nameSpaceXades, nomElement);
        digestElement.setPrefix(prefixXades);
        Element digestMethod = document.createElementNS(nameSpaceDsig, "DigestMethod");
        digestMethod.setPrefix(prefixDsig);
        digestElement.appendChild(digestMethod);
        digestMethod.setAttributeNS(null, "Algorithm", typeAlgorithmHash.getAlgoDigestMethod());
        Element digestValue = document.createElementNS(nameSpaceDsig, "DigestValue");
        digestValue.setPrefix(prefixDsig);
        digestElement.appendChild(digestValue);
        byte[] hash = HashUtil.genererHashShaBinaire(typeAlgorithmHash, infosEncodes);
        String hashEnBase64 = Base64.encodeBytes(hash);
        Text textDigestValueCrtRef = document.createTextNode(hashEnBase64);
        digestValue.appendChild(textDigestValueCrtRef);
        return digestElement;
    }

    private static Element creerElementCert(Document document, String prefixXades, String nameSpaceDsig, String prefixDsig, X509Certificate certificate, TypeAlgorithmHash typeAlgorithmHash) throws CertificateEncodingException {
        Element cert = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "Cert");
        cert.setPrefix(prefixXades);
        Element certDigest = SignatureXades.creerElementDigest(document, typeAlgorithmHash.getNameSpaceVersionXades(), prefixXades, nameSpaceDsig, prefixDsig, "CertDigest", certificate.getEncoded(), typeAlgorithmHash);
        cert.appendChild(certDigest);
        Element x509IssuerSerial = SignatureXades.creerElementIssuerSerial(document, typeAlgorithmHash.getNameSpaceVersionXades(), prefixXades, nameSpaceDsig, prefixDsig, certificate);
        cert.appendChild(x509IssuerSerial);
        return cert;
    }

    private static Element creerElementCRLRef(Document document, String prefixXades, String nameSpaceDsig, String prefixDsig, X509CRL crl, TypeAlgorithmHash typeAlgorithmHash) throws CRLException {
        Element crlRef = document.createElementNS(typeAlgorithmHash.getNameSpaceVersionXades(), "CRLRef");
        crlRef.setPrefix(prefixXades);
        Element certDigest = SignatureXades.creerElementDigest(document, typeAlgorithmHash.getNameSpaceVersionXades(), prefixXades, nameSpaceDsig, prefixDsig, "DigestAlgAndValue", crl.getEncoded(), typeAlgorithmHash);
        crlRef.appendChild(certDigest);
        Element crlIdentifier = SignatureXades.creerElementCRLIdentifier(document, typeAlgorithmHash.getNameSpaceVersionXades(), prefixXades, crl);
        crlRef.appendChild(crlIdentifier);
        return crlRef;
    }

    private static Element creerElementCRLIdentifier(Document document, String nameSpaceXades, String prefixXades, X509CRL crl) {
        Element crlIdentifier = document.createElementNS(nameSpaceXades, "CRLIdentifier");
        crlIdentifier.setPrefix(prefixXades);
        Element issuer = document.createElementNS(nameSpaceXades, "Issuer");
        issuer.setPrefix(prefixXades);
        crlIdentifier.appendChild(issuer);
        Text textX509IssuerName = document.createTextNode(crl.getIssuerX500Principal().getName("RFC1779"));
        issuer.appendChild(textX509IssuerName);
        Element issueTime = document.createElementNS(nameSpaceXades, "IssueTime");
        issueTime.setPrefix(prefixXades);
        crlIdentifier.appendChild(issueTime);
        String date = Util.creerISO8601DateTime(crl.getThisUpdate());
        Text textIssueTime = document.createTextNode(date);
        issueTime.appendChild(textIssueTime);
        return crlIdentifier;
    }

    public static Date getDateSignature(String contenuSignatureXML) {
        Date dateSignature = null;
        String baliseOuvrante = "<xades:SigningTime>";
        String baliseFermante = "</xades:SigningTime>";
        if (contenuSignatureXML != null && contenuSignatureXML.contains(baliseOuvrante) && contenuSignatureXML.contains(baliseFermante)) {
            int positionDebutSignature = contenuSignatureXML.indexOf(baliseOuvrante);
            int positionFinSignature = contenuSignatureXML.indexOf(baliseFermante);
            String dateSignatureString = contenuSignatureXML.substring(positionDebutSignature + baliseOuvrante.length(), positionFinSignature);
            if (dateSignatureString != null) {
                try {
                    if (!dateSignatureString.contains("T")) {
                        try {
                            dateSignature = Util.convertirDate(SignatureXades.extraireDate(dateSignatureString), "yyyyMMddHHmmss");
                        }
                        catch (ParseException e) {}
                    } else {
                        dateSignature = Util.convertirISO8601DateTime(dateSignatureString);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        return dateSignature;
    }

    public static String getSigningTime(String contenuFichierXML) {
        int positionDebut = contenuFichierXML.indexOf("<xades:SigningTime>");
        int positionFin = contenuFichierXML.indexOf("</xades:SigningTime>");
        String date = contenuFichierXML.substring(positionDebut + "<xades:SigningTime>".length(), positionFin);
        return date;
    }

    public static String extraireDate(String dateSignature) {
        String date = Util.remplacerPar(dateSignature, new String[]{" ", ":", "-", "T"}, "");
        if (date.length() > 14) {
            date = date.substring(0, 14);
        }
        return date;
    }
}

