/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.securite.signature;

import java.security.Key;
import java.security.PublicKey;
import javax.security.cert.X509Certificate;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;

public class X509KeySelector
extends KeySelector {
    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        for (XMLStructure info : keyInfo.getContent()) {
            if (!(info instanceof X509Data)) continue;
            X509Data x509Data = (X509Data)info;
            for (Object o : x509Data.getContent()) {
                if (!(o instanceof X509Certificate)) continue;
                final PublicKey key = ((X509Certificate)o).getPublicKey();
                if (!X509KeySelector.isAlgorithmValid(method.getAlgorithm(), key.getAlgorithm())) continue;
                return new KeySelectorResult(){

                    @Override
                    public Key getKey() {
                        return key;
                    }
                };
            }
        }
        throw new KeySelectorException("No key found!");
    }

    static boolean isAlgorithmValid(String algorithmURI, String algorithm) {
        boolean estDSA = algorithm.equalsIgnoreCase("DSA") && algorithmURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        boolean estRSA = algorithm.equalsIgnoreCase("RSA") && algorithmURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        return estDSA || estRSA;
    }
}

