/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class I18nUtil {
    public static final String BUNDLE_PAR_DEFAUT = "messages";

    public static String get(String key) {
        return I18nUtil.get(BUNDLE_PAR_DEFAUT, key, Locale.getDefault());
    }

    public static String get(String bundle, String key) {
        return I18nUtil.get(bundle, key, Locale.getDefault());
    }

    public static String get(String bundle, String key, Locale locale) {
        String value = null;
        try {
            value = ResourceBundle.getBundle(bundle, locale).getString(key);
        }
        catch (MissingResourceException e) {
            value = "@@" + key + "@@";
        }
        return value;
    }

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len != 2 && len != 5 && len < 7) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch0 = str.charAt(0);
        char ch1 = str.charAt(1);
        if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (len == 2) {
            return new Locale(str, "");
        }
        if (str.charAt(2) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch3 = str.charAt(3);
        if (ch3 == '_') {
            return new Locale(str.substring(0, 2), "", str.substring(4));
        }
        char ch4 = str.charAt(4);
        if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (len == 5) {
            return new Locale(str.substring(0, 2), str.substring(3, 5));
        }
        if (str.charAt(5) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        return new Locale(str.substring(0, 2), str.substring(3, 5), str.substring(6));
    }
}

