/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.util;

import fr.atexo.commun.jaxb.JAXBService;
import fr.atexo.signature.commun.util.Util;
import fr.atexo.signature.util.AffichageUtil;
import fr.atexo.signature.xml.annonce.ObjectFactory;
import fr.atexo.signature.xml.annonce.ReponseAnnonce;
import fr.atexo.signature.xml.annonce.ReponseAnnonceType;
import fr.atexo.signature.xml.annonce.ReponsesAnnonce;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JaxbReponsesAnnonceUtil {
    private static final ObjectFactory factory = new ObjectFactory();

    public static ReponsesAnnonce getReponsesAnnonce(String reponsesAnnonceXML) {
        return JaxbReponsesAnnonceUtil.getReponsesAnnonce(reponsesAnnonceXML, "UTF-8");
    }

    public static ReponsesAnnonce getReponsesAnnonce(String reponsesAnnonceXML, String encoding) {
        String context = ReponsesAnnonce.class.getPackage().getName();
        Object reponsesAnnonceObject = JAXBService.instance().getAsObject(reponsesAnnonceXML, context, encoding);
        return (ReponsesAnnonce)reponsesAnnonceObject;
    }

    public static ReponsesAnnonce creerReponsesAnnonce() {
        ReponsesAnnonce reponsesAnnonce = factory.createReponsesAnnonce();
        ReponseAnnonceType reponseAnnonce = factory.createReponseAnnonceType();
        reponsesAnnonce.getReponseAnnonce().add(reponseAnnonce);
        ReponseAnnonceType.Enveloppes enveloppes = factory.createReponseAnnonceTypeEnveloppes();
        reponseAnnonce.setEnveloppes(enveloppes);
        return reponsesAnnonce;
    }

    public static ReponseAnnonce creerReponseAnnonce() {
        ReponseAnnonce reponseAnnonce = factory.createReponseAnnonce();
        ReponseAnnonceType.Enveloppes enveloppes = factory.createReponseAnnonceTypeEnveloppes();
        reponseAnnonce.setEnveloppes(enveloppes);
        return reponseAnnonce;
    }

    public static ReponseAnnonceType.Enveloppes.Enveloppe creerEnveloppe(int typeEnveloppe, int numeroLot, boolean ouverte, boolean chiffree, String statutAdmissibilite) {
        ReponseAnnonceType.Enveloppes.Enveloppe enveloppe = factory.createReponseAnnonceTypeEnveloppesEnveloppe();
        enveloppe.setType(typeEnveloppe);
        enveloppe.setNumLot(numeroLot);
        enveloppe.setStatutAdmissibilite(statutAdmissibilite);
        String statutChiffrement = chiffree ? "CHI" : "NCH";
        enveloppe.setStatutChiffrement(statutChiffrement);
        String statutOuverture = ouverte ? "OUV" : "FER";
        enveloppe.setStatutOuverture(statutOuverture);
        return enveloppe;
    }

    public static ReponseAnnonceType.Enveloppes.Enveloppe.Fichier creerFichier(String nomFichier, String typeFichier, String origineFichier, int numeroFichier, int tailleFichier, String empreinte, String signature, boolean chiffree, boolean hashFichier, int nombreBlocs) {
        ReponseAnnonceType.Enveloppes.Enveloppe.Fichier fichier = factory.createReponseAnnonceTypeEnveloppesEnveloppeFichier();
        fichier.setNom(nomFichier);
        fichier.setTypeFichier(typeFichier);
        fichier.setOrigineFichier(origineFichier);
        fichier.setNumOrdre(numeroFichier);
        fichier.setTailleEnClair(tailleFichier);
        fichier.setEmpreinte(empreinte);
        fichier.setSignature(signature);
        fichier.setHash(hashFichier);
        String statutChiffrement = chiffree ? "CHI" : "NCH";
        fichier.setStatutChiffrement(statutChiffrement);
        fichier.setNbrBlocsChiffrement(nombreBlocs);
        ReponseAnnonceType.Enveloppes.Enveloppe.Fichier.BlocsChiffrement blocsChiffrement = factory.createReponseAnnonceTypeEnveloppesEnveloppeFichierBlocsChiffrement();
        blocsChiffrement.setNbrBlocs(nombreBlocs);
        fichier.setBlocsChiffrement(blocsChiffrement);
        return fichier;
    }

    public static ReponseAnnonceType.Enveloppes.Enveloppe.Fichier.BlocsChiffrement.BlocChiffrement creerBlocChiffrement(boolean chiffree, String empreinte, Integer tailleEnClair, Integer tailleApresChiffrement, int numeroBloc) {
        ReponseAnnonceType.Enveloppes.Enveloppe.Fichier.BlocsChiffrement.BlocChiffrement blocChiffrement = factory.createReponseAnnonceTypeEnveloppesEnveloppeFichierBlocsChiffrementBlocChiffrement();
        blocChiffrement.setEmpreinte(empreinte);
        String statutChiffrement = chiffree ? "CHI" : "NCH";
        blocChiffrement.setStatutChiffrement(statutChiffrement);
        blocChiffrement.setTailleEnClair(tailleEnClair);
        blocChiffrement.setTailleApresChiffrement(tailleApresChiffrement);
        blocChiffrement.setNumOrdre(numeroBloc);
        return blocChiffrement;
    }

    public static Map<Integer, List<FichierBloc>> extraireFichierBlocChiffrements(ReponsesAnnonce reponsesAnnonce, Set<Integer> idEnveloppes) {
        HashMap<Integer, List<FichierBloc>> map = new HashMap<Integer, List<FichierBloc>>();
        for (ReponseAnnonceType reponseAnnonceType : reponsesAnnonce.getReponseAnnonce()) {
            ReponseAnnonceType.Annonce annonce = reponseAnnonceType.getAnnonce();
            ReponseAnnonceType.OperateurEconomique operateurEconomique = reponseAnnonceType.getOperateurEconomique();
            for (ReponseAnnonceType.Enveloppes.Enveloppe enveloppe : reponseAnnonceType.getEnveloppes().getEnveloppe()) {
                List<FichierBloc> fichierBlocsTemporaire;
                if (idEnveloppes != null && (idEnveloppes == null || !idEnveloppes.contains(enveloppe.getIdEnveloppe()))) continue;
                ArrayList<FichierBloc> fichierBlocs = (ArrayList<FichierBloc>)map.get(enveloppe.getIdEnveloppe());
                if (fichierBlocs == null) {
                    fichierBlocs = new ArrayList<FichierBloc>();
                    map.put(enveloppe.getIdEnveloppe(), fichierBlocs);
                }
                if ((fichierBlocsTemporaire = JaxbReponsesAnnonceUtil.extraireFichierBlocChiffrements(annonce, enveloppe, operateurEconomique)) == null || fichierBlocsTemporaire.isEmpty()) continue;
                fichierBlocs.addAll(fichierBlocsTemporaire);
            }
        }
        return map;
    }

    public static List<FichierBloc> extraireFichierBlocChiffrements(ReponseAnnonceType.Annonce annonce, ReponseAnnonceType.Enveloppes.Enveloppe enveloppe, ReponseAnnonceType.OperateurEconomique operateurEconomique) {
        ArrayList<FichierBloc> liste = new ArrayList<FichierBloc>();
        String nomRepertoireEnveloppe = "El" + enveloppe.getIdEnveloppe() + "_" + AffichageUtil.getTypeEnvNomRepertoire(enveloppe.getType(), enveloppe.getNumLot());
        for (ReponseAnnonceType.Enveloppes.Enveloppe.Fichier fichier : enveloppe.getFichier()) {
            ArrayList<FichierBloc.Bloc> blocs = new ArrayList<FichierBloc.Bloc>();
            for (ReponseAnnonceType.Enveloppes.Enveloppe.Fichier.BlocsChiffrement.BlocChiffrement blocChiffrement : fichier.getBlocsChiffrement().getBlocChiffrement()) {
                Integer id = blocChiffrement.getNomBloc() != null ? Integer.valueOf(blocChiffrement.getNomBloc()) : null;
                Integer numero = blocChiffrement.getNumOrdre();
                Integer taille = blocChiffrement.getTailleApresChiffrement();
                boolean chiffre = "CHI".equals(blocChiffrement.getStatutChiffrement());
                FichierBloc.Bloc bloc = new FichierBloc.Bloc(id, numero, taille.intValue(), chiffre);
                blocs.add(bloc);
            }
            String informationsUtilisateur = annonce != null ? annonce.getReferenceUtilisateur() : null;
            FichierBloc fichierBloc = new FichierBloc(enveloppe.getType(), enveloppe.getNumLot(), fichier.getNom(), blocs, informationsUtilisateur, fichier.getSignature(), fichier.getTailleEnClair().intValue());
            fichierBloc.setNomEnveloppe(nomRepertoireEnveloppe);
            if (operateurEconomique != null && !Util.estVide(operateurEconomique.getNom())) {
                fichierBloc.setNomOperateurEconomique(operateurEconomique.getNom());
            }
            liste.add(fichierBloc);
        }
        return liste;
    }

    public static int getNombreDeBlocChiffrement(File fichier) {
        long l = fichier.length() / 0x400000L;
        if (fichier.length() % 0x400000L == 0L) {
            return (int)fichier.length() / 0x400000;
        }
        return (int)fichier.length() / 0x400000 + 1;
    }

    public static class FichierBloc {
        protected int typeEnveloppe;
        protected int numeroLot;
        private String nomEnveloppe;
        private String nomOperateurEconomique;
        private String nomFichier;
        private List<Bloc> blocs = new ArrayList<Bloc>();
        private String referenceUtilisateur;
        private String signatureXades;
        private long taille;

        public FichierBloc(int typeEnveloppe, int numeroLot, String nomFichier, List<Bloc> blocs, String referenceUtilisateur, String signatureXades, long taille) {
            this.typeEnveloppe = typeEnveloppe;
            this.numeroLot = numeroLot;
            this.nomFichier = nomFichier;
            this.blocs = blocs;
            this.referenceUtilisateur = referenceUtilisateur;
            this.signatureXades = signatureXades;
            this.taille = taille;
        }

        public int getTypeEnveloppe() {
            return this.typeEnveloppe;
        }

        public int getNumeroLot() {
            return this.numeroLot;
        }

        public String getNomFichier() {
            return this.nomFichier;
        }

        public List<Bloc> getBlocs() {
            return this.blocs;
        }

        public String getReferenceUtilisateur() {
            return this.referenceUtilisateur;
        }

        public String getSignatureXades() {
            return this.signatureXades;
        }

        public long getTaille() {
            return this.taille;
        }

        public String getNomEnveloppe() {
            return this.nomEnveloppe;
        }

        public void setNomEnveloppe(String nomEnveloppe) {
            this.nomEnveloppe = nomEnveloppe;
        }

        public String getNomOperateurEconomique() {
            return this.nomOperateurEconomique;
        }

        public void setNomOperateurEconomique(String nomOperateurEconomique) {
            this.nomOperateurEconomique = nomOperateurEconomique;
        }

        public static class Bloc {
            private Integer id;
            private Integer numero;
            private long tailleChiffre;
            private boolean chiffre;

            public Bloc(Integer id, Integer numero, long tailleChiffre, boolean chiffre) {
                this.id = id;
                this.numero = numero;
                this.tailleChiffre = tailleChiffre;
                this.chiffre = chiffre;
            }

            public Integer getId() {
                return this.id;
            }

            public long getTailleChiffre() {
                return this.tailleChiffre;
            }

            public boolean isChiffre() {
                return this.chiffre;
            }

            public Integer getNumero() {
                return this.numero;
            }
        }
    }
}

