/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.util;

import fr.atexo.signature.commun.securite.provider.TypeOs;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.exception.ExceptionUtils;

public abstract class Util {
    static final int[] CARACTERES_ILLEGAUX_NOM_FICHIER = new int[]{34, 60, 62, 124, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 58, 42, 63, 92, 47};
    public static final String DATE_PATTERN_SLASH = "dd/MM/yyyy";
    public static final String DATE_TIME_PATTERN_TIRET = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_PATTERN_YYYMMDD = "yyyyMMdd";
    public static final String DATE_TIME_PATTERN_YYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String DATE_TIME_PATTERN_YYYMMDDHHMMSSSS = "yyyyMMddHHmmssSS";

    public static String creerISO8601DateTime(Date date) {
        int minutes;
        int hours;
        SimpleDateFormat ISO8601Local = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone timeZone = TimeZone.getDefault();
        ISO8601Local.setTimeZone(timeZone);
        int offset = timeZone.getOffset(date.getTime());
        String sign = "+";
        if (offset < 0) {
            offset = -offset;
            sign = "-";
        }
        if (offset != (hours = offset / 3600000) * 3600000 + (minutes = (offset - hours * 3600000) / 60000) * 60000) {
            throw new RuntimeException("TimeZone offset (" + sign + offset + " ms) is not an exact number of minutes");
        }
        DecimalFormat twoDigits = new DecimalFormat("00");
        String ISO8601Now = ISO8601Local.format(date) + sign + twoDigits.format(hours) + ":" + twoDigits.format(minutes);
        return ISO8601Now;
    }

    public static Date convertirISO8601DateTime(String dateISO8601) {
        Date date = null;
        try {
            Calendar calendar = DatatypeConverter.parseDateTime((String)dateISO8601);
            if (calendar != null) {
                date = calendar.getTime();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return date;
    }

    public static String formaterDate(Date date) {
        return Util.formaterDate(date, DATE_PATTERN_SLASH);
    }

    public static String formaterDate(Date date, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }

    public static Date convertirDate(String date, String pattern) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.parse(date);
    }

    public static boolean isExpire(Date dateExpiration) {
        return dateExpiration.before(new Date());
    }

    public static boolean verifierJavaVersion(int version) {
        String javaVersion = System.getProperty("java.version");
        int iJavaVersion = Integer.parseInt(javaVersion.replace(".", "").replace("_", "").substring(0, 2));
        return iJavaVersion >= version;
    }

    public static TypeProvider determinerProvider() {
        String architecture = System.getProperty("os.arch");
        String nomOs = System.getProperty("os.name");
        String version = System.getProperty("java.specification.version");
        String bits = System.getProperty("sun.arch.data.model");
        return Util.determinerProvider(architecture, nomOs, version, bits);
    }

    public static TypeProvider determinerProvider(String architecture, String nomOs, String version, String bits) {
        Double versionParse = Double.parseDouble(version);
        if (nomOs.startsWith("Windows") && versionParse > Double.parseDouble("1.5")) {
            if (bits.equals("32")) {
                return TypeProvider.MSCAPI;
            }
            return Double.parseDouble(version) > Double.parseDouble("1.6") ? TypeProvider.MSCAPI : TypeProvider.PKCS12;
        }
        if (nomOs.startsWith("Mac")) {
            return TypeProvider.APPLE;
        }
        if (nomOs.startsWith("Linux")) {
            return TypeProvider.PKCS11;
        }
        return TypeProvider.PKCS12;
    }

    public static TypeOs determinerOs() {
        String nomOs = System.getProperty("os.name");
        if (nomOs.startsWith("Windows")) {
            return TypeOs.Windows;
        }
        if (nomOs.startsWith("Mac")) {
            return TypeOs.MacOs;
        }
        if (nomOs.startsWith("Linux")) {
            return TypeOs.Linux;
        }
        return TypeOs.Indetermine;
    }

    public static boolean estVide(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static double arrondir(double valeur, int precision) {
        return (double)((int)(valeur * Math.pow(10.0, precision) + 0.5)) / Math.pow(10.0, precision);
    }

    public static String remplacerPar(String chaine, String[] occurances, String valeur) {
        if (chaine == null) {
            return null;
        }
        String nouvelleChaine = chaine;
        for (String occurance : occurances) {
            nouvelleChaine = nouvelleChaine.replaceAll(occurance, valeur);
        }
        return nouvelleChaine;
    }

    public static String remplacerPar(String chaine, String occurance, String valeur) {
        return Util.remplacerPar(chaine, new String[]{occurance}, valeur);
    }

    public static String getFullStacktraceException(String message, Throwable cause) {
        String stacktrace = ExceptionUtils.getFullStackTrace(cause);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(message);
        stringBuffer.append("\n");
        stringBuffer.append(stacktrace);
        return stringBuffer.toString();
    }

    public static String supprimerNomFichierCaracteresNonSupportes(String nomFichier) {
        StringBuilder nomFichierModifie = new StringBuilder();
        for (int i = 0; i < nomFichier.length(); ++i) {
            char c = nomFichier.charAt(i);
            if (Arrays.binarySearch(CARACTERES_ILLEGAUX_NOM_FICHIER, (int)c) >= 0) continue;
            nomFichierModifie.append(c);
        }
        return nomFichierModifie.toString();
    }

    public static boolean isDateCompriseEntre(Date dateComparaitre, Date dateDebut, Date dateFin) {
        return dateDebut.before(dateComparaitre) && dateFin.after(dateComparaitre);
    }
}

