/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.commun.util.io;

import fr.atexo.signature.commun.securite.signature.TypeAlgorithmHash;
import fr.atexo.signature.commun.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;

public abstract class HashUtil {
    public static String genererHashShaHexadecimal(TypeAlgorithmHash typeAlgorithmHash, byte[] donnees) {
        return typeAlgorithmHash == TypeAlgorithmHash.SHA1 ? HashUtil.genererHashSha1Hexadecimal(donnees) : HashUtil.genererHashSha256Hexadecimal(donnees);
    }

    public static String genererHashShaHexadecimal(TypeAlgorithmHash typeAlgorithmHash, File fichier) throws IOException {
        return typeAlgorithmHash == TypeAlgorithmHash.SHA1 ? HashUtil.genererHashSha1Hexadecimal(fichier) : HashUtil.genererHashSha256Hexadecimal(fichier);
    }

    public static byte[] genererHashShaBinaire(TypeAlgorithmHash typeAlgorithmHash, byte[] donnees) {
        return typeAlgorithmHash == TypeAlgorithmHash.SHA1 ? HashUtil.genererHashSha1Binaire(donnees) : HashUtil.genererHashSha256Binaire(donnees);
    }

    public static byte[] genererHashShaBinaire(TypeAlgorithmHash typeAlgorithmHash, File fichier) throws IOException {
        return typeAlgorithmHash == TypeAlgorithmHash.SHA1 ? HashUtil.genererHashSha1Binaire(fichier) : HashUtil.genererHashSha256Binaire(fichier);
    }

    public static String genererHashSha1Hexadecimal(byte[] donnees) {
        return HashUtil.genererHashSha1Hexadecimal(donnees, donnees.length);
    }

    public static String genererHashSha1Hexadecimal(byte[] donnees, int longueur) {
        byte[] hashResult = HashUtil.genererHashBinaire(new SHA1Digest(), donnees, longueur);
        return HashUtil.convertirBinaireEnHexadecimal(hashResult);
    }

    public static byte[] genererHashSha1Binaire(byte[] donnees) {
        return HashUtil.genererHashSha1Binaire(donnees, donnees.length);
    }

    public static byte[] genererHashSha1Binaire(byte[] donnees, int longueur) {
        byte[] hashResult = HashUtil.genererHashBinaire(new SHA1Digest(), donnees, longueur);
        return hashResult;
    }

    public static String genererHashSha256Hexadecimal(byte[] donnees) {
        return HashUtil.genererHashSha256Hexadecimal(donnees, donnees.length);
    }

    public static String genererHashSha256Hexadecimal(byte[] donnees, int longueur) {
        byte[] hashResult = HashUtil.genererHashBinaire(new SHA256Digest(), donnees, longueur);
        return HashUtil.convertirBinaireEnHexadecimal(hashResult);
    }

    public static byte[] genererHashSha256Binaire(byte[] donnees) {
        return HashUtil.genererHashSha256Binaire(donnees, donnees.length);
    }

    public static byte[] genererHashSha256Binaire(byte[] donnees, int longueur) {
        byte[] hashResult = HashUtil.genererHashBinaire(new SHA256Digest(), donnees, longueur);
        return hashResult;
    }

    public static byte[] genererHashBinaire(GeneralDigest algorithmHash, byte[] donnees, int longueur) {
        algorithmHash.update(donnees, 0, longueur);
        byte[] hashResult = new byte[algorithmHash.getDigestSize()];
        algorithmHash.doFinal(hashResult, 0);
        return hashResult;
    }

    public static String genererHashSha256Hexadecimal(File fichier) throws IOException {
        return HashUtil.genererHashHexadecimal(new SHA256Digest(), fichier);
    }

    public static String genererHashSha1Hexadecimal(File fichier) throws IOException {
        return HashUtil.genererHashHexadecimal(new SHA1Digest(), fichier);
    }

    public static byte[] genererHashSha256Binaire(File fichier) throws IOException {
        return HashUtil.genererHashBinaire(new SHA256Digest(), fichier);
    }

    public static byte[] genererHashSha1Binaire(File fichier) throws IOException {
        return HashUtil.genererHashBinaire(new SHA1Digest(), fichier);
    }

    public static String genererHashHexadecimal(GeneralDigest algorithmHash, File fichier) throws IOException {
        byte[] hashResult = HashUtil.genererHashBinaire(algorithmHash, fichier);
        return HashUtil.convertirBinaireEnHexadecimal(hashResult);
    }

    public static byte[] genererHashBinaire(GeneralDigest algorithmHash, File fichier) throws IOException {
        int tailleMaximale = (int)fichier.length();
        int fin = 0x400000;
        int tailleATraiter = 0;
        int indexFichier = 0;
        indexFichier = 0;
        while (indexFichier * fin <= tailleMaximale) {
            tailleATraiter = indexFichier * fin + fin <= tailleMaximale ? fin : tailleMaximale - indexFichier * fin;
            byte[] contentBytes = FileUtil.lire(fichier, indexFichier * fin, tailleATraiter);
            algorithmHash.update(contentBytes, 0, tailleATraiter);
            ++indexFichier;
        }
        byte[] hashResult = new byte[algorithmHash.getDigestSize()];
        algorithmHash.doFinal(hashResult, 0);
        return hashResult;
    }

    public static String convertirBinaireEnHexadecimal(byte[] hashBinaire) {
        if (hashBinaire == null) {
            return "";
        }
        char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer sb = new StringBuffer(hashBinaire.length * 2);
        for (int i = 0; i < hashBinaire.length; ++i) {
            sb.append(hexChar[(hashBinaire[i] & 0xF0) >>> 4]);
            sb.append(hexChar[hashBinaire[i] & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] convertirHexadecimalEnBinaire(String hashHexadecimal) {
        int len = hashHexadecimal.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hashHexadecimal.charAt(i), 16) << 4) + Character.digit(hashHexadecimal.charAt(i + 1), 16));
        }
        return data;
    }
}

