/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.dechiffrement.horsligne;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import fr.atexo.signature.commun.util.I18nUtil;
import fr.atexo.signature.commun.util.JaxbReponsesAnnonceUtil;
import fr.atexo.signature.dechiffrement.horsligne.EnveloppeTableForm;
import fr.atexo.signature.dechiffrement.horsligne.LogDetails;
import fr.atexo.signature.dechiffrement.horsligne.information.InfosEnveloppe;
import fr.atexo.signature.dechiffrement.horsligne.model.AnnonceTableModel;
import fr.atexo.signature.gui.browser.SelectionRepertoire;
import fr.atexo.signature.xml.annonce.ReponseAnnonceType;
import fr.atexo.signature.xml.annonce.ReponsesAnnonce;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.io.FileUtils;
import org.jdesktop.layout.GroupLayout;

public class DecipherForm
extends JFrame {
    private ReponsesAnnonce reponsesAnnonce = null;
    private List<ReponseAnnonceType.Annonce> listeAnnonces = new ArrayList<ReponseAnnonceType.Annonce>();
    private Map<Integer, List<InfosEnveloppe>> mapEnveloppes = new HashMap<Integer, List<InfosEnveloppe>>();
    private File repertoire;
    private JTable annonceTable;
    private JTextField cheminPlis;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel18;
    private JLabel jLabel20;
    private JPanel jPanel1;
    private JPanel jPanel13;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JLabel logs;
    private JLabel messageOuvrirAnnonce;
    private JLabel newFileDestination;
    private JButton ouvrirButton;
    private JButton parcourirButton;

    public DecipherForm() {
        this.initComponents();
        this.messageOuvrirAnnonce.setEnabled(false);
        this.ouvrirButton.setEnabled(false);
        this.setTitle(I18nUtil.get("OUTIL_DCHFFRMENT_HORS_LIGNE"));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/signature.png")));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/images/quitter.gif")));
        this.logs.setIcon(new ImageIcon(this.getClass().getResource("/images/logs.gif")));
        this.setResizable(false);
        try {
            PlasticLookAndFeel.setPlasticTheme(new ExperienceBlue());
            UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.windowDimension();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jPanel13 = new JPanel();
        this.jLabel18 = new JLabel();
        this.jLabel20 = new JLabel();
        this.cheminPlis = new JTextField();
        this.parcourirButton = new JButton();
        this.newFileDestination = new JLabel();
        this.jPanel8 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.annonceTable = new JTable();
        this.ouvrirButton = new JButton();
        this.messageOuvrirAnnonce = new JLabel();
        this.logs = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setFocusTraversalPolicy(null);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText(I18nUtil.get("FERMER"));
        this.jLabel1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DecipherForm.this.jLabel1MouseClicked(evt);
            }
        });
        this.jLabel11.setFont(new Font("Tahoma", 0, 24));
        this.jLabel11.setForeground(new Color(0, 103, 153));
        this.jLabel11.setText(I18nUtil.get("OUTIL_DCHFFRMENT_HORS_LIGNE"));
        this.jPanel13.setBackground(new Color(255, 255, 255));
        this.jPanel13.setBorder(BorderFactory.createTitledBorder(I18nUtil.get("SELECTIONNEZ_LE_REPERTOIRE_DESTINATION")));
        this.jLabel18.setText(I18nUtil.get("DESIGNER_REPERTOIRE_CONTENANT_PLIS"));
        this.jLabel20.setText(I18nUtil.get("CHEMIN_DIRECTORY"));
        this.cheminPlis.setDebugGraphicsOptions(-1);
        this.parcourirButton.setText(I18nUtil.get("PARCOURIR"));
        this.parcourirButton.setDebugGraphicsOptions(-1);
        this.parcourirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DecipherForm.this.parcourirButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel13Layout = new GroupLayout(this.jPanel13);
        this.jPanel13.setLayout(jPanel13Layout);
        jPanel13Layout.setHorizontalGroup(jPanel13Layout.createParallelGroup(1).add(jPanel13Layout.createSequentialGroup().addContainerGap().add(this.jLabel18, -2, 811, -2).add(35, 35, 35)).add(jPanel13Layout.createSequentialGroup().add(76, 76, 76).add(this.newFileDestination, -1, 780, Short.MAX_VALUE)).add(jPanel13Layout.createSequentialGroup().addContainerGap().add(this.jLabel20, -2, 125, -2).addPreferredGap(0).add(this.cheminPlis, -2, 448, -2).add(51, 51, 51).add(this.parcourirButton, -2, 105, -2).addContainerGap(113, Short.MAX_VALUE)));
        jPanel13Layout.setVerticalGroup(jPanel13Layout.createParallelGroup(1).add(jPanel13Layout.createSequentialGroup().addContainerGap().add(this.jLabel18).add(18, 18, 18).add(jPanel13Layout.createParallelGroup(3).add(this.cheminPlis, -2, -1, -2).add(this.parcourirButton).add(this.jLabel20)).add(56, 56, 56).add(this.newFileDestination, -1, -1, Short.MAX_VALUE)));
        this.jPanel8.setBackground(new Color(255, 255, 255));
        this.jPanel8.setBorder(BorderFactory.createTitledBorder(I18nUtil.get("LISTE_ANNONCES")));
        this.annonceTable.setForeground(new Color(0, 51, 255));
        this.annonceTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{I18nUtil.get("REF_TYPE"), I18nUtil.get("OBJET"), I18nUtil.get("DATE_LIMITE")}));
        this.annonceTable.setDebugGraphicsOptions(-1);
        this.annonceTable.setGridColor(new Color(204, 204, 204));
        this.annonceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DecipherForm.this.annonceTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.annonceTable);
        this.ouvrirButton.setText(I18nUtil.get("OUVRIR"));
        this.ouvrirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DecipherForm.this.ouvrirButtonActionPerformed(evt);
            }
        });
        this.messageOuvrirAnnonce.setText(I18nUtil.get("MESSAGE_DETAIL_ANNONCE"));
        GroupLayout jPanel8Layout = new GroupLayout(this.jPanel8);
        this.jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(jPanel8Layout.createParallelGroup(1).add(jPanel8Layout.createSequentialGroup().addContainerGap().add(jPanel8Layout.createParallelGroup(1).add(jPanel8Layout.createSequentialGroup().add(jPanel8Layout.createParallelGroup(1).add(this.messageOuvrirAnnonce, -1, 836, Short.MAX_VALUE).add(this.jScrollPane1, -1, 836, Short.MAX_VALUE)).addContainerGap()).add(2, jPanel8Layout.createSequentialGroup().add(this.ouvrirButton, -2, 105, -2).add(97, 97, 97)))));
        jPanel8Layout.setVerticalGroup(jPanel8Layout.createParallelGroup(1).add(jPanel8Layout.createSequentialGroup().addContainerGap().add(this.jScrollPane1, -2, 115, -2).addPreferredGap(1).add(this.messageOuvrirAnnonce).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.ouvrirButton)));
        this.logs.setFont(new Font("Tahoma", 1, 11));
        this.logs.setText(I18nUtil.get("LOGS"));
        this.logs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DecipherForm.this.logsMouseClicked(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(2).add(1, this.jPanel8, -1, -1, Short.MAX_VALUE).add(1, this.jPanel13, -1, -1, Short.MAX_VALUE).add(1, jPanel1Layout.createSequentialGroup().add(this.jLabel11, -2, 698, -2).addPreferredGap(1).add(this.logs).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.jLabel1))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.logs))).add(this.jLabel11, -2, 54, -2)).add(16, 16, 16).add(this.jPanel13, -2, 103, -2).add(32, 32, 32).add(this.jPanel8, -2, -1, -2).addContainerGap(45, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(this.jPanel1, -2, -1, -2));
        this.pack();
    }

    private void logsMouseClicked(MouseEvent evt) {
        LogDetails logDetails = new LogDetails();
        logDetails.setVisible(true);
    }

    private void annonceTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 1) {
            this.messageOuvrirAnnonce.setEnabled(true);
            this.ouvrirButton.setEnabled(true);
        }
    }

    private void parcourirButtonActionPerformed(ActionEvent evt) {
        this.reponsesAnnonce = null;
        String cheminRepertoire = this.selectionnerRepertoire();
        this.cheminPlis.setText(cheminRepertoire);
        this.repertoire = new File(cheminRepertoire);
        File fichierReponseAnnonce = new File(this.repertoire, "ReponsesAnnonce.xml");
        if (fichierReponseAnnonce.exists() && fichierReponseAnnonce.isFile()) {
            try {
                this.reponsesAnnonce = this.getReponsesAnnonce(fichierReponseAnnonce);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.extraireInformations(this.reponsesAnnonce);
            AnnonceTableModel annonceTableModel = new AnnonceTableModel(this.listeAnnonces);
            this.annonceTable.setModel(annonceTableModel);
            this.messageOuvrirAnnonce.setEnabled(false);
            this.ouvrirButton.setEnabled(false);
        } else {
            JOptionPane.showMessageDialog(null, I18nUtil.get("AUCUNE_ANNONCE_TROUVE"), I18nUtil.get("SELECTIONNEZ_LE_REPERTOIRE_DESTINATION"), 1);
        }
    }

    private void extraireInformations(ReponsesAnnonce reponsesAnnonce) {
        HashMap<Integer, ReponseAnnonceType.Annonce> mapAnnonces = new HashMap<Integer, ReponseAnnonceType.Annonce>();
        mapAnnonces.clear();
        this.mapEnveloppes.clear();
        for (ReponseAnnonceType reponseAnnonceType : reponsesAnnonce.getReponseAnnonce()) {
            Integer idAnnonce = Integer.valueOf(reponseAnnonceType.getAnnonce().getReference());
            ReponseAnnonceType.Annonce annonce = (ReponseAnnonceType.Annonce)mapAnnonces.get(idAnnonce);
            if (annonce == null) {
                mapAnnonces.put(idAnnonce, reponseAnnonceType.getAnnonce());
            }
            for (ReponseAnnonceType.Enveloppes.Enveloppe enveloppe : reponseAnnonceType.getEnveloppes().getEnveloppe()) {
                List<InfosEnveloppe> enveloppes = this.mapEnveloppes.get(idAnnonce);
                if (enveloppes == null) {
                    enveloppes = new ArrayList<InfosEnveloppe>();
                    this.mapEnveloppes.put(idAnnonce, enveloppes);
                }
                InfosEnveloppe infosEnveloppe = new InfosEnveloppe(enveloppe.getIdEnveloppe(), enveloppe, reponseAnnonceType.getOperateurEconomique(), reponseAnnonceType.getHorodatageDepot());
                enveloppes.add(infosEnveloppe);
            }
        }
        this.listeAnnonces = Arrays.asList(mapAnnonces.values().toArray(new ReponseAnnonceType.Annonce[mapAnnonces.size()]));
    }

    private void ouvrirButtonActionPerformed(ActionEvent evt) {
        ReponseAnnonceType.Annonce annonceSelectionne = this.listeAnnonces.get(this.annonceTable.getSelectedRow());
        List<InfosEnveloppe> enveloppes = this.mapEnveloppes.get(Integer.valueOf(annonceSelectionne.getReference()));
        Collections.sort(enveloppes);
        Integer idEnveloppe = null;
        int index = 0;
        for (InfosEnveloppe infosEnveloppe : enveloppes) {
            if (idEnveloppe == null || idEnveloppe != infosEnveloppe.getIdEnveloppe()) {
                idEnveloppe = infosEnveloppe.getIdEnveloppe();
                ++index;
            }
            infosEnveloppe.setNomEnveloppe(I18nUtil.get("EL") + index);
        }
        EnveloppeTableForm enveloppeTableFrm = new EnveloppeTableForm(this.repertoire, annonceSelectionne, enveloppes);
        enveloppeTableFrm.setVisible(true);
    }

    private void jLabel1MouseClicked(MouseEvent evt) {
        System.exit(0);
    }

    private void windowDimension() {
        Toolkit kit = this.getToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Insets in = kit.getScreenInsets(gs[0].getDefaultConfiguration());
        Dimension d = kit.getScreenSize();
        int max_width = d.width - in.left - in.right;
        int max_height = d.height - in.top - in.bottom;
        this.setSize(Math.min(max_width, 892), Math.min(max_height, 460));
        this.setLocation((max_width - this.getWidth()) / 2, (max_height - this.getHeight()) / 2);
    }

    private String selectionnerRepertoire() {
        SelectionRepertoire selectionRepertoire = new SelectionRepertoire();
        if (selectionRepertoire.showOpenDialog(null) == 0) {
            if (selectionRepertoire.getSelectedFile().getAbsolutePath().length() != 0) {
                return selectionRepertoire.getSelectedFile().getAbsolutePath();
            }
            return "";
        }
        return "";
    }

    private ReponsesAnnonce getReponsesAnnonce(File fichierReponseAnnonce) throws IOException {
        String contenuReponsesAnnonceXML = FileUtils.readFileToString(fichierReponseAnnonce, "ISO-8859-1");
        System.out.println(contenuReponsesAnnonceXML);
        ReponsesAnnonce reponsesAnnonce = JaxbReponsesAnnonceUtil.getReponsesAnnonce(contenuReponsesAnnonceXML, "ISO-8859-1");
        return reponsesAnnonce;
    }
}

