/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.dechiffrement.horsligne;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import fr.atexo.signature.commun.exception.execution.CertificatDechiffrementIntrouvableException;
import fr.atexo.signature.commun.exception.execution.DechiffrementExecutionException;
import fr.atexo.signature.commun.securite.processor.chiffrement.DechiffrementProcessor;
import fr.atexo.signature.commun.securite.provider.TypeOs;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import fr.atexo.signature.commun.securite.signature.SignatureXades;
import fr.atexo.signature.commun.util.I18nUtil;
import fr.atexo.signature.commun.util.JaxbReponsesAnnonceUtil;
import fr.atexo.signature.commun.util.Util;
import fr.atexo.signature.commun.util.io.XMLUtil;
import fr.atexo.signature.dechiffrement.horsligne.information.InfosEnveloppe;
import fr.atexo.signature.dechiffrement.horsligne.model.EnveloppeTableModel;
import fr.atexo.signature.processor.StandardChiffrementProcessor;
import fr.atexo.signature.util.AffichageUtil;
import fr.atexo.signature.util.FileNameCleaner;
import fr.atexo.signature.xml.annonce.ReponseAnnonceType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import net.iharder.Base64;
import org.apache.commons.io.FileUtils;
import org.jdesktop.layout.GroupLayout;

public class EnveloppeTableForm
extends JFrame {
    private TypeOs typeOs = Util.determinerOs();
    private TypeProvider typeProvider = Util.determinerProvider();
    private ReponseAnnonceType.Annonce annonce;
    private List<InfosEnveloppe> enveloppes;
    private DechiffrementProcessor dechiffrementProcessor;
    private File repertoire;
    private JButton dechiffrerButton;
    private JTable enveloppeTable;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JTextArea messageDechiffrerPlis;

    public EnveloppeTableForm(File repertoire, ReponseAnnonceType.Annonce annonce, List<InfosEnveloppe> enveloppes) {
        this.initComponents();
        this.windowDimension();
        this.repertoire = repertoire;
        this.annonce = annonce;
        this.enveloppes = enveloppes;
        try {
            PlasticLookAndFeel.setPlasticTheme(new ExperienceBlue());
            UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.setTitle(I18nUtil.get("LISTE_PLIS_CONSULTATION"));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/images/signature.png")));
        this.setResizable(false);
        this.messageDechiffrerPlis.setEnabled(false);
        this.dechiffrerButton.setEnabled(false);
        this.enveloppeTable.setModel(new EnveloppeTableModel(enveloppes));
        this.enveloppeTable.repaint();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.enveloppeTable = new JTable();
        this.messageDechiffrerPlis = new JTextArea();
        this.messageDechiffrerPlis.setEditable(false);
        this.messageDechiffrerPlis.setLineWrap(true);
        this.messageDechiffrerPlis.setOpaque(false);
        this.messageDechiffrerPlis.setBorder(BorderFactory.createEmptyBorder());
        this.messageDechiffrerPlis.setFont(UIManager.getFont("Label.font"));
        this.dechiffrerButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setBackground(new Color(204, 255, 255));
        this.setFocusTraversalPolicy(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EnveloppeTableForm.this.closeEnveloppeTableForm(evt);
            }
        });
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.enveloppeTable.setForeground(new Color(0, 51, 255));
        this.enveloppeTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}}, new String[]{I18nUtil.get("NUM_PLI"), I18nUtil.get("TYPE_PLI"), I18nUtil.get("DATE_DEPOT"), I18nUtil.get("RAISON_SOCIALE")}));
        this.enveloppeTable.setDebugGraphicsOptions(-1);
        this.enveloppeTable.setGridColor(new Color(204, 204, 204));
        this.enveloppeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EnveloppeTableForm.this.enveloppeTableMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.enveloppeTable);
        this.messageDechiffrerPlis.setText(I18nUtil.get("MESSAGE_DECHIFFRER_PLIS"));
        this.dechiffrerButton.setText(I18nUtil.get("OUVRIR"));
        this.dechiffrerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EnveloppeTableForm.this.dechiffrerButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(this.jScrollPane2, -1, 798, Short.MAX_VALUE).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.messageDechiffrerPlis, -1, 778, Short.MAX_VALUE).addContainerGap()).add(2, jPanel1Layout.createSequentialGroup().addContainerGap(683, Short.MAX_VALUE).add(this.dechiffrerButton, -2, 105, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().add(this.jScrollPane2, -1, 220, Short.MAX_VALUE).addPreferredGap(0).add(this.messageDechiffrerPlis).addPreferredGap(0).add(this.dechiffrerButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void dechiffrerButtonActionPerformed(ActionEvent evt) {
        int[] rows = this.enveloppeTable.getSelectedRows();
        ArrayList<InfosEnveloppe> enveloppesSelectionnees = new ArrayList<InfosEnveloppe>(rows.length);
        int nombreTotalFichiers = 0;
        for (int i : rows) {
            InfosEnveloppe infosEnveloppe = this.enveloppes.get(i);
            String nomRepertoireEnveloppe = infosEnveloppe.getNomEnveloppe() + "_" + AffichageUtil.getTypeEnvNomRepertoire(infosEnveloppe.getEnveloppe().getType(), infosEnveloppe.getEnveloppe().getNumLot());
            infosEnveloppe.setNomRepertoireEnveloppe(nomRepertoireEnveloppe);
            enveloppesSelectionnees.add(infosEnveloppe);
            nombreTotalFichiers += infosEnveloppe.getEnveloppe().getFichier().size();
        }
        this.dechiffrerEnveloppes(nombreTotalFichiers, enveloppesSelectionnees.toArray(new InfosEnveloppe[enveloppesSelectionnees.size()]));
    }

    private void enveloppeTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            Point p = evt.getPoint();
            int row = this.enveloppeTable.rowAtPoint(p);
            int column = this.enveloppeTable.convertColumnIndexToModel(this.enveloppeTable.columnAtPoint(p));
            int nombreTotalFichiers = 0;
            if (row >= 0 && column >= 0) {
                ArrayList<InfosEnveloppe> enveloppesSelectionnees = new ArrayList<InfosEnveloppe>(1);
                InfosEnveloppe infosEnveloppe = this.enveloppes.get(this.enveloppeTable.getSelectedRow());
                if (infosEnveloppe != null) {
                    enveloppesSelectionnees.add(infosEnveloppe);
                    nombreTotalFichiers += infosEnveloppe.getEnveloppe().getFichier().size();
                }
                this.dechiffrerEnveloppes(nombreTotalFichiers, enveloppesSelectionnees.toArray(new InfosEnveloppe[enveloppesSelectionnees.size()]));
            }
        }
        if (evt.getClickCount() == 1) {
            this.messageDechiffrerPlis.setEnabled(true);
            this.dechiffrerButton.setEnabled(true);
        }
    }

    private void dechiffrerEnveloppes(int nombreTotalFichiers, InfosEnveloppe ... infosEnveloppes) {
        try {
            this.onSelection(nombreTotalFichiers, infosEnveloppes);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, I18nUtil.get("ERREUR_PLI_INTROUVABLE_SUR_LE_POSTE") + " " + I18nUtil.get("ERREUR_VERIFIER_TELECHARGEMENT_PLI"), I18nUtil.get("ERREUR"), 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CertificatDechiffrementIntrouvableException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, I18nUtil.get("CLE_DECHIFFREMENT_INTROUVABLE"), I18nUtil.get("ERREUR"), 0);
        }
        catch (DechiffrementExecutionException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, I18nUtil.get("ERREUR_DEPOUILLEMENT"), I18nUtil.get("ERREUR"), 0);
        }
    }

    private void onSelection(int nombreTotalFichiers, InfosEnveloppe ... infosEnveloppes) throws IOException, DechiffrementExecutionException {
        List<JaxbReponsesAnnonceUtil.FichierBloc> blocs;
        this.dechiffrementProcessor = new StandardChiffrementProcessor(this.typeProvider, null);
        String nomFichiersDechiffres = "";
        for (InfosEnveloppe infosEnveloppe : infosEnveloppes) {
            blocs = JaxbReponsesAnnonceUtil.extraireFichierBlocChiffrements(this.annonce, infosEnveloppe.getEnveloppe(), null);
            File repertoireEnveloppe = this.repertoire;
            if (infosEnveloppe.getNomRepertoireEnveloppe() != null) {
                String nomRepertoireOperateurEconomique;
                String string = nomRepertoireOperateurEconomique = infosEnveloppe.getOperateurEconomique() != null ? infosEnveloppe.getOperateurEconomique().getNom() : null;
                if (nomRepertoireOperateurEconomique != null) {
                    nomRepertoireOperateurEconomique = FileNameCleaner.cleanFileName(nomRepertoireOperateurEconomique);
                    File repertoireOperateurEconomique = new File(this.repertoire, nomRepertoireOperateurEconomique);
                    repertoireEnveloppe = new File(repertoireOperateurEconomique, infosEnveloppe.getNomRepertoireEnveloppe());
                } else {
                    repertoireEnveloppe = new File(this.repertoire, infosEnveloppe.getNomRepertoireEnveloppe());
                }
            }
            nomFichiersDechiffres = nomFichiersDechiffres + "\n" + repertoireEnveloppe.getAbsolutePath();
            for (JaxbReponsesAnnonceUtil.FichierBloc fichierBloc : blocs) {
                File fichier = new File(repertoireEnveloppe, fichierBloc.getNomFichier());
                for (JaxbReponsesAnnonceUtil.FichierBloc.Bloc bloc : fichierBloc.getBlocs()) {
                    String id = bloc.getId() != null ? bloc.getId().toString() : bloc.getNumero().toString();
                    File fichierPart = new File(this.repertoire, id);
                    if (!fichierPart.exists()) {
                        throw new FileNotFoundException("Impossible de trouver le fichier ayant comme nom " + id + " dans le r\u00e9pertoire " + this.repertoire.getAbsolutePath());
                    }
                    byte[] contenuBloc = Base64.decodeFromFile(fichierPart.getAbsolutePath());
                    if (bloc.isChiffre()) {
                        contenuBloc = this.dechiffrementProcessor.dechiffrer(new String(contenuBloc));
                    }
                    if (!repertoireEnveloppe.exists()) {
                        repertoireEnveloppe.mkdirs();
                    }
                    FileUtils.writeByteArrayToFile(fichier, contenuBloc, true);
                }
                String signatureXades = fichierBloc.getSignatureXades();
                if (Util.estVide(signatureXades)) continue;
                signatureXades = new String(Base64.decode(signatureXades));
                String dateSignature = SignatureXades.extraireDate(SignatureXades.getSigningTime(signatureXades));
                String nomFichierSignature = XMLUtil.contruireCheminFichierSignatureXML(fichierBloc.getNomFichier(), dateSignature, 1);
                File fichierSignature = new File(repertoireEnveloppe, nomFichierSignature);
                FileUtils.writeByteArrayToFile(fichierSignature, signatureXades.getBytes());
            }
        }
        for (InfosEnveloppe infosEnveloppe : infosEnveloppes) {
            blocs = JaxbReponsesAnnonceUtil.extraireFichierBlocChiffrements(this.annonce, infosEnveloppe.getEnveloppe(), null);
            for (JaxbReponsesAnnonceUtil.FichierBloc fichierBloc : blocs) {
                for (JaxbReponsesAnnonceUtil.FichierBloc.Bloc bloc : fichierBloc.getBlocs()) {
                    String id = bloc.getId() != null ? bloc.getId().toString() : bloc.getNumero().toString();
                    File fichierPart = new File(this.repertoire, id);
                    if (!fichierPart.exists()) continue;
                    fichierPart.delete();
                }
            }
        }
        JOptionPane.showMessageDialog(this, I18nUtil.get("MSG_FIN_TRAITEMENT_SUCCES") + nomFichiersDechiffres);
    }

    private void closeEnveloppeTableForm(WindowEvent evt) {
        this.dispose();
    }

    private void windowDimension() {
        Toolkit kit = this.getToolkit();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        Insets in = kit.getScreenInsets(gs[0].getDefaultConfiguration());
        Dimension d = kit.getScreenSize();
        int max_width = d.width - in.left - in.right;
        int max_height = d.height - in.top - in.bottom;
        this.setSize(Math.min(max_width, 856), Math.min(max_height, 250));
        this.setLocation((max_width - this.getWidth()) / 2, (max_height - this.getHeight()) / 2);
    }
}

