/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.dechiffrement.horsligne.model;

import fr.atexo.signature.commun.util.I18nUtil;
import fr.atexo.signature.dechiffrement.EnveloppeUtil;
import fr.atexo.signature.dechiffrement.horsligne.information.InfosEnveloppe;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class EnveloppeTableModel
extends AbstractTableModel {
    private List<InfosEnveloppe> enveloppes;
    private static final int NUM_PLI = 0;
    private static final int TYPE_PLI = 1;
    private static final int DATE_DEPOT = 2;
    private static final int RAISON_SOCIALE = 3;
    public static final String[] columnNames = new String[]{I18nUtil.get("NUM_PLI"), I18nUtil.get("TYPE_PLI"), I18nUtil.get("DATE_DEPOT"), I18nUtil.get("RAISON_SOCIALE")};

    public EnveloppeTableModel(List<InfosEnveloppe> enveloppes) {
        this.enveloppes = enveloppes;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.enveloppes.size();
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int column) {
        InfosEnveloppe infosEnveloppe = this.enveloppes.get(row);
        switch (column) {
            case 0: {
                return infosEnveloppe.getNomEnveloppe();
            }
            case 1: {
                return EnveloppeUtil.getTypeEnvLibelle(infosEnveloppe.getEnveloppe().getType(), infosEnveloppe.getEnveloppe().getNumLot());
            }
            case 2: {
                return infosEnveloppe.getHorodatageDepot();
            }
            case 3: {
                return infosEnveloppe.getOperateurEconomique() != null ? infosEnveloppe.getOperateurEconomique().getNom() : "";
            }
        }
        return null;
    }
}

