/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.gui.barreprogression;

import fr.atexo.signature.commun.util.I18nUtil;
import java.awt.HeadlessException;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BarreDeProgression
extends JFrame
implements ChangeListener {
    private JProgressBar progressionTraitementFichier;
    private JProgressBar progressionGlobale;
    private JProgressBar progressionUnitaire;
    private String messageProgressionTraitementFichier;
    private String messageProgressionGlobale;

    public BarreDeProgression(int nombreFichiers) throws HeadlessException {
        this(I18nUtil.get("SWING_BARREPROGRESSION_TITRE"), nombreFichiers);
    }

    public BarreDeProgression(String titre, int nombreFichiers) throws HeadlessException {
        super(titre);
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        this.progressionTraitementFichier = new JProgressBar(1, nombreFichiers + 1);
        this.progressionTraitementFichier.addChangeListener(this);
        this.progressionTraitementFichier.setStringPainted(true);
        this.progressionGlobale = new JProgressBar();
        this.progressionGlobale.setMinimum(1);
        this.progressionGlobale.addChangeListener(this);
        this.progressionGlobale.setStringPainted(true);
        this.progressionUnitaire = new JProgressBar(1, 100);
        this.progressionUnitaire.setStringPainted(true);
        this.add(this.progressionTraitementFichier);
        this.add(this.progressionGlobale);
        this.add(this.progressionUnitaire);
        this.setBounds(320, 240, 600, 100);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void initialiserFichier(boolean chiffrementRequis, boolean telechargementRequis, boolean uploadRequis, boolean signaturePadesRequise, boolean signatureXadesRequise, int nombreBlocs) {
        int nombreTraitementsParFichier = 0;
        if (signaturePadesRequise) {
            ++nombreTraitementsParFichier;
        }
        if (signatureXadesRequise) {
            ++nombreTraitementsParFichier;
        }
        if (chiffrementRequis) {
            nombreTraitementsParFichier = nombreBlocs;
        }
        if (telechargementRequis) {
            nombreTraitementsParFichier = nombreBlocs;
        }
        if (uploadRequis) {
            nombreTraitementsParFichier += nombreBlocs;
        }
        this.initialiserFichier(nombreTraitementsParFichier);
    }

    public void initialiserFichier(int nombreTraitements) {
        this.progressionGlobale.setMaximum(nombreTraitements + 1);
    }

    public void incrementerProgressionTraitementFichier() {
        this.progressionTraitementFichier.setValue(this.progressionTraitementFichier.getValue() + 1);
    }

    public void setMessageProgressionTraitementFichier(String message) {
        this.messageProgressionTraitementFichier = message;
    }

    public void incrementerProgressionGlobale() {
        this.progressionGlobale.setValue(this.progressionGlobale.getValue() + 1);
        try {
            this.validerProgressionUnitaire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.reinitialiserProgressionUnitaire();
    }

    public void setMessageProgressionGlobale(String message) {
        this.messageProgressionGlobale = message;
    }

    private void validerProgressionUnitaire() throws InterruptedException {
        for (int i = 2; i < 101; ++i) {
            this.progressionUnitaire.setValue(i);
            Thread.sleep(2L);
        }
    }

    private void reinitialiserProgressionUnitaire() {
        this.progressionUnitaire.setValue(1);
    }

    public void reinitialiserProgressionGlobale() {
        this.progressionGlobale.setValue(1);
        this.reinitialiserProgressionUnitaire();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.progressionTraitementFichier.setString(this.messageProgressionTraitementFichier);
        this.progressionGlobale.setString(this.messageProgressionGlobale);
    }
}

