/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.gui.provider.magasin;

import fr.atexo.signature.commun.securite.provider.CertificatItem;
import fr.atexo.signature.commun.securite.provider.TypeOs;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import fr.atexo.signature.commun.securite.provider.magasin.MagasinHandler;
import fr.atexo.signature.commun.securite.provider.pkcs11.Pkcs11Handler;
import fr.atexo.signature.commun.util.CertificatUtil;
import fr.atexo.signature.gui.provider.CertificateSelectUiService;
import fr.atexo.signature.gui.provider.magasin.event.MagasinCertificateListener;
import fr.atexo.signature.gui.provider.magasin.ui.MainFrame;
import fr.atexo.signature.logging.LogManager;
import fr.atexo.signature.util.SmartCardUtil;
import fr.atexo.signature.xml.pkcs11.Pkcs11LibsType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class MagasinCertificateUiService
implements CertificateSelectUiService<MagasinCertificateListener> {
    private static MagasinCertificateUiService uiService;
    private static Pkcs11LibsType pkcs11Libs;

    public static MagasinCertificateUiService getInstance(Pkcs11LibsType pkcs11Libs) {
        if (uiService == null) {
            uiService = new MagasinCertificateUiService();
        }
        MagasinCertificateUiService.pkcs11Libs = pkcs11Libs;
        return uiService;
    }

    @Override
    public void initUi(MagasinCertificateListener listener, TypeOs typeOs, TypeProvider typeProvider, boolean filtrerSignatureModeRGS, CertificatUtil.TypeCertificat ... typeCertificat) {
        ArrayList<CertificatItem> certificatItems = new ArrayList<CertificatItem>();
        try {
            HashSet<String> hashCodes = new HashSet<String>();
            if (pkcs11Libs != null) {
                if (pkcs11Libs != null && typeOs != TypeOs.Windows) {
                    Map<String, List<File>> providers = SmartCardUtil.getPkcs11Providers(pkcs11Libs, typeOs);
                    if (providers != null && providers.size() > 0) {
                        List<CertificatItem> certificatsPkcs11 = Pkcs11Handler.getInstance().recupererCertificats(providers, hashCodes, filtrerSignatureModeRGS, typeCertificat);
                        certificatItems.addAll(certificatsPkcs11);
                    } else {
                        LogManager.getInstance().afficherMessageWarning("Aucune librairie pkcs11 n'a \u00e9t\u00e9 trouv\u00e9 au niveau de l'installation du poste client => pas de dialogue avec de potentiel smartcard", this.getClass());
                    }
                }
            } else {
                LogManager.getInstance().afficherMessageWarning("Aucune librairie t\u00e9l\u00e9chargeable vu que l'url de r\u00e9f\u00e9rence est injoignable ou incorrect", this.getClass());
            }
            if (typeOs == TypeOs.Windows || typeOs == TypeOs.MacOs) {
                List<CertificatItem> certificatsMagasin = MagasinHandler.getInstance().recupererCertificats(typeProvider, hashCodes, filtrerSignatureModeRGS, typeCertificat);
                certificatItems.addAll(certificatsMagasin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MainFrame mainFrame = new MainFrame(certificatItems);
        mainFrame.addListener(listener);
    }
}

