/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.gui.provider.magasin.ui;

import fr.atexo.signature.commun.securite.provider.CertificatItem;
import fr.atexo.signature.commun.util.I18nUtil;
import fr.atexo.signature.commun.util.Util;
import fr.atexo.signature.gui.provider.AbstractMainFrame;
import fr.atexo.signature.gui.provider.magasin.event.MagasinCertificateEvent;
import fr.atexo.signature.gui.provider.magasin.ui.TableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class MainFrame
extends AbstractMainFrame<MagasinCertificateEvent>
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private List<CertificatItem> certificateItems;
    public static final int width = 765;
    public static final int height = 300;
    private JTable table;
    private JButton validerButton;
    private JButton annulerButton;

    public MainFrame(List<CertificatItem> certificatItems) {
        this.certificateItems = certificatItems;
        this.build();
        this.setVisible(true);
    }

    private void build() {
        this.setTitle(I18nUtil.get("SWING_MSCAPI_LISTE_TITRE"));
        this.setSize(765, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.buildContentPane());
    }

    private JPanel buildContentPane() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        TableModel tableModel = new TableModel(new String[]{I18nUtil.get("SWING_MSCAPI_LISTE_NOM_CERTIFICAT"), I18nUtil.get("SWING_MSCAPI_LISTE_NOM_EMETTEUR"), I18nUtil.get("SWING_MSCAPI_LISTE_DATE_EXPIRATION"), I18nUtil.get("SWING_MSCAPI_LISTE_UTILISATION_CLE")}, this.certificateItems);
        this.table = new JTable();
        this.table.setModel(tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        TableColumn column = this.table.getColumnModel().getColumn(2);
        column.setPreferredWidth(100);
        TableColumn column1 = this.table.getColumnModel().getColumn(1);
        column1.setPreferredWidth(120);
        TableColumn column2 = this.table.getColumnModel().getColumn(0);
        column2.setPreferredWidth(175);
        TableColumn column3 = this.table.getColumnModel().getColumn(3);
        column3.setPreferredWidth(370);
        JScrollPane scroller = new JScrollPane(this.table);
        scroller.setVerticalScrollBar(new JScrollBar());
        mainPanel.add((Component)scroller, "Center");
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        this.validerButton = new JButton(I18nUtil.get("SWING_ACTION_VALIDER"));
        this.validerButton.addActionListener(this);
        this.annulerButton = new JButton(I18nUtil.get("SWING_ACTION_ANNULER"));
        this.annulerButton.addActionListener(this);
        bottomPanel.add((Component)this.annulerButton, "West");
        bottomPanel.add((Component)this.validerButton, "East");
        mainPanel.add((Component)bottomPanel, "Last");
        return mainPanel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.annulerButton) {
            this.dispose();
            return;
        }
        int index = this.table.getSelectedRow();
        if (index >= 0) {
            int userClic;
            MagasinCertificateEvent event = new MagasinCertificateEvent(this, this.certificateItems.get(index));
            CertificatItem item = this.certificateItems.get(index);
            if (Util.isExpire(item.getDateExpiration()) && (userClic = JOptionPane.showConfirmDialog(this, I18nUtil.get("SWING_ACTION_ALERTE_PAR_DEFAUT_CERTIFICAT_PERIME"), I18nUtil.get("SWING_ACTION_ALERTE"), 0)) != 0) {
                return;
            }
            this.fireCertificateEvent(event);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, I18nUtil.get("SWING_ACTION_ALERTE_SELECTIONNER_CERTIFICAT"), I18nUtil.get("SWING_ACTION_ALERTE"), 2);
        }
    }
}

