/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.gui.provider.pkcs12.ui;

import fr.atexo.signature.commun.util.I18nUtil;
import fr.atexo.signature.gui.browser.ui.ExtensionFileFilter;
import fr.atexo.signature.gui.provider.AbstractMainFrame;
import fr.atexo.signature.gui.provider.pkcs12.event.Pkcs12CertificateEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MainFrame
extends AbstractMainFrame<Pkcs12CertificateEvent>
implements ActionListener {
    private static final long serialVersionUID = -1835196612081409281L;
    public static final int width = 600;
    public static final int height = 160;
    private JButton validerButton;
    private JButton annulerButton;
    private JButton parcourirButton;
    private JTextField cheminFichierCertificatField;
    private JTextField motDePasseField;

    public MainFrame() {
        this.build();
        this.setVisible(true);
    }

    private void build() {
        this.setTitle(I18nUtil.get("SWING_PKCS12_TITRE"));
        this.setSize(600, 160);
        this.setLocationRelativeTo(null);
        this.buildContainer(this.getContentPane());
    }

    private void buildContainer(Container container) {
        container.setLayout(new GridBagLayout());
        JLabel cheminFichierCertificatLabel = new JLabel(I18nUtil.get("SWING_PKCS12_CHEMIN_CERTIFICAT"));
        JLabel motDePasseLabel = new JLabel(I18nUtil.get("SWING_PKCS12_MOT_DE_PASSE"));
        this.cheminFichierCertificatField = new JTextField();
        this.motDePasseField = new JPasswordField();
        this.parcourirButton = new JButton(I18nUtil.get("SWING_ACTION_PARCOURIR"));
        this.parcourirButton.addActionListener(this);
        this.annulerButton = new JButton(I18nUtil.get("SWING_ACTION_ANNULER"));
        this.annulerButton.addActionListener(this);
        this.annulerButton.setPreferredSize(this.parcourirButton.getPreferredSize());
        this.validerButton = new JButton(I18nUtil.get("SWING_ACTION_VALIDER"));
        this.validerButton.addActionListener(this);
        this.validerButton.setPreferredSize(this.parcourirButton.getPreferredSize());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 512;
        gbc.insets = new Insets(0, 10, 0, 0);
        container.add((Component)cheminFichierCertificatLabel, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = -1;
        gbc.anchor = 512;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 10, 0, 5);
        container.add((Component)this.cheminFichierCertificatField, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 0;
        gbc.anchor = 512;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 10);
        container.add((Component)this.parcourirButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 512;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        container.add((Component)motDePasseLabel, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 0;
        gbc.anchor = 512;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 10, 0, 10);
        container.add((Component)this.motDePasseField, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 768;
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 0, 10, 5);
        container.add((Component)this.annulerButton, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(5, 0, 10, 10);
        container.add((Component)this.validerButton, gbc);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.annulerButton) {
            this.dispose();
            return;
        }
        if (source == this.parcourirButton) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFileChooser chooser = new JFileChooser();
                    ExtensionFileFilter filter = new ExtensionFileFilter("P12", new String[]{"P12"});
                    chooser.setFileFilter(filter);
                    chooser.setApproveButtonText(I18nUtil.get("SWING_PKCS12_SELECTIONNER"));
                    if (chooser.showOpenDialog(MainFrame.this) == 0) {
                        MainFrame.this.cheminFichierCertificatField.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                }
            });
        } else if (source == this.validerButton) {
            if (this.cheminFichierCertificatField.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, I18nUtil.get("SWING_ACTION_ALERTE_SELECTIONNER_CERTIFICAT"), I18nUtil.get("SWING_ACTION_ALERTE"), 2);
            } else if (this.motDePasseField.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, I18nUtil.get("SWING_PKCS12_ACTION_ERREUR_MOT_DE_PASSE"), I18nUtil.get("SWING_ACTION_ERREUR"), 0);
            } else {
                Pkcs12CertificateEvent certEvt = new Pkcs12CertificateEvent(this, this.cheminFichierCertificatField.getText(), this.motDePasseField.getText());
                this.fireCertificateEvent(certEvt);
                this.dispose();
            }
        } else {
            this.dispose();
            return;
        }
    }
}

