/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpRequest {
    private static final String BOUNDARY = "---------------------------7d22bb3b890472";
    private static final String CONTENT_DISPOSITION = "Content-Disposition: form-data; name=\"";
    private static final String FIN = "--";
    private static final String FIN_FICHIER = "\"";
    private static final String LIGNE = "\r\n";
    private static final String METHOD_POST = "POST";
    private HttpURLConnection connection;
    private OutputStream outputStream;

    public HttpRequest(final URL url, final boolean modePost) throws Exception {
        final boolean modeHttps = url.getProtocol().equals("https");
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (modeHttps) {
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    SSLContext sslContext = SSLContext.getInstance("SSL");
                    sslContext.init(null, trustAllCerts, new SecureRandom());
                    HostnameVerifier hostnameVerifier = new HostnameVerifier(){

                        @Override
                        public boolean verify(String urlHostName, SSLSession session) {
                            return true;
                        }
                    };
                    HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
                    HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                }
                HttpRequest.this.connection = (HttpURLConnection)url.openConnection();
                if (modePost) {
                    HttpRequest.this.connection.setRequestMethod(HttpRequest.METHOD_POST);
                    HttpRequest.this.connection.setDoOutput(true);
                    HttpRequest.this.connection.setDoInput(true);
                    HttpRequest.this.connection.setUseCaches(false);
                    HttpRequest.this.connection.setAllowUserInteraction(true);
                    HttpRequest.this.connection.addRequestProperty("Content-Type", "multipart/form-data; boundary=---------------------------7d22bb3b890472");
                    HttpRequest.this.connection.addRequestProperty("Connection", "Keep-Alive");
                    HttpRequest.this.connection.addRequestProperty("Cache-Control", "no-cache");
                    HttpRequest.this.outputStream = HttpRequest.this.connection.getOutputStream();
                }
                return null;
            }
        });
    }

    public void ajouterFichier(String nom, File fichier) throws IOException {
        byte[] buffer = new byte[(int)fichier.length()];
        FileInputStream fis = new FileInputStream(fichier);
        ((InputStream)fis).read(buffer, 0, buffer.length);
        this.ajouterFichier(nom, fichier.getName(), buffer);
        ((InputStream)fis).close();
    }

    public void ajouterFichier(String nom, String nomFichier, byte[] contenuFichier) throws IOException {
        this.preparerMetadonneesFichier(nom, nomFichier);
        this.outputStream.write(contenuFichier);
    }

    private void preparerMetadonneesFichier(String nom, String nomFichier) throws IOException {
        this.outputStream.write(LIGNE.getBytes());
        this.outputStream.write(FIN.getBytes());
        this.outputStream.write(BOUNDARY.getBytes());
        this.outputStream.write(LIGNE.getBytes());
        this.outputStream.write((CONTENT_DISPOSITION + nom + FIN_FICHIER).getBytes());
        this.outputStream.write(("; filename=\"" + nomFichier + FIN_FICHIER).getBytes());
        this.outputStream.write(LIGNE.getBytes());
        this.outputStream.write(LIGNE.getBytes());
    }

    public void ajouterContenu(String nom, String valeur) throws IOException {
        this.outputStream.write(LIGNE.getBytes());
        this.outputStream.write(FIN.getBytes());
        this.outputStream.write(BOUNDARY.getBytes());
        this.outputStream.write(LIGNE.getBytes());
        this.outputStream.write((CONTENT_DISPOSITION + nom + FIN_FICHIER).getBytes());
        this.outputStream.write(LIGNE.getBytes());
        this.outputStream.write(LIGNE.getBytes());
        this.outputStream.write(valeur.getBytes());
    }

    public void ajouterContenu(String nom, Integer valeur) throws IOException {
        this.ajouterContenu(nom, valeur != null ? String.valueOf(valeur) : null);
    }

    public InputStream envoyer() throws IOException {
        this.outputStream.write(LIGNE.getBytes());
        this.outputStream.write(FIN.getBytes());
        this.outputStream.write(BOUNDARY.getBytes());
        this.outputStream.write(FIN.getBytes());
        this.outputStream.flush();
        this.outputStream.close();
        return this.getInputStream();
    }

    public void deconnecter() {
        this.connection.disconnect();
    }

    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }
}

