/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.logging;

import fr.atexo.signature.commun.util.Util;
import fr.atexo.signature.logging.SingleLineLogFormatter;
import java.io.File;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public abstract class LoggerFactory {
    private static String nomLogger;
    private static File fichier;
    private static File FILE_LOG;

    private LoggerFactory() {
    }

    public static Logger getLogger(String nom) {
        if (!LoggerFactory.isExiste(nom)) {
            Logger logger = Logger.getLogger(nom);
            LogManager.getLogManager().reset();
            SingleLineLogFormatter singleLineLogFormatter = new SingleLineLogFormatter(true, true);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(singleLineLogFormatter);
            logger.addHandler(consoleHandler);
            try {
                FileHandler fileHandler = new FileHandler(FILE_LOG.getPath(), true);
                fileHandler.setFormatter(singleLineLogFormatter);
                logger.addHandler(fileHandler);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return logger;
        }
        return Logger.getLogger(nom);
    }

    public static String getNomLogger() {
        return nomLogger;
    }

    public static void setNomLogger(String nomLogger) {
        LoggerFactory.nomLogger = nomLogger;
        try {
            File fichierTemporaire = File.createTempFile("fichiertemp", ".tmp");
            String cheminRepertoireTemporaireSysteme = fichierTemporaire.getParent();
            String date = Util.formaterDate(new Date(), "yyyyMMdd");
            fichier = new File(new File(cheminRepertoireTemporaireSysteme), nomLogger + "_" + date + ".log");
            if (!fichier.exists()) {
                fichier.createNewFile();
            }
            fichierTemporaire.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FILE_LOG = fichier;
    }

    public static File getFichier() {
        return fichier;
    }

    public static void changerLoggerLevel(String nom, Level levelConsole, Level levelFichier) {
        if (LoggerFactory.isExiste(nom) && (levelConsole != null || levelFichier != null)) {
            Logger logger = LoggerFactory.getLogger(nom);
            for (Handler handler : logger.getHandlers()) {
                if (levelConsole != null && handler instanceof ConsoleHandler) {
                    handler.setLevel(levelConsole);
                    continue;
                }
                if (levelFichier == null || !(handler instanceof FileHandler)) continue;
                handler.setLevel(levelFichier);
            }
        }
    }

    public static boolean isExiste(String nom) {
        return LogManager.getLogManager().getLogger(nom) != null;
    }
}

