/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.logging;

import fr.atexo.signature.commun.util.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class SingleLineLogFormatter
extends Formatter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private boolean utiliserNomClasse;
    private boolean utiliserNomMethode;

    public SingleLineLogFormatter() {
        this(false, false);
    }

    public SingleLineLogFormatter(boolean utiliserNomClasse, boolean utiliserNomMethode) {
        this.utiliserNomClasse = utiliserNomClasse;
        this.utiliserNomMethode = utiliserNomMethode;
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder stringBuilder = new StringBuilder();
        Date date = new Date(record.getMillis());
        String dateFormat = Util.formaterDate(date, "yyyy-MM-dd HH:mm:ss");
        stringBuilder.append(dateFormat).append(" ");
        stringBuilder.append(record.getLevel().getLocalizedName()).append(" ");
        if (this.isUtiliserNomClasse() && record.getSourceClassName() != null) {
            stringBuilder.append("[").append(record.getSourceClassName()).append("]").append(" ");
            if (this.isUtiliserNomMethode() && record.getSourceMethodName() != null) {
                stringBuilder.append("[").append(record.getSourceMethodName()).append("]").append(" ");
            }
        } else {
            stringBuilder.append("[").append(record.getLoggerName()).append("]").append(" ");
        }
        stringBuilder.append(": ").append(this.formatMessage(record)).append(LINE_SEPARATOR);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                stringBuilder.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return stringBuilder.toString();
    }

    public boolean isUtiliserNomClasse() {
        return this.utiliserNomClasse;
    }

    public boolean isUtiliserNomMethode() {
        return this.utiliserNomMethode;
    }
}

