/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.processor;

import fr.atexo.signature.commun.exception.certificat.RecuperationCertificatException;
import fr.atexo.signature.commun.exception.execution.CertificatDechiffrementIntrouvableException;
import fr.atexo.signature.commun.exception.execution.ChiffrementExecutionException;
import fr.atexo.signature.commun.exception.execution.DechiffrementExecutionException;
import fr.atexo.signature.commun.securite.certificat.KeyPair;
import fr.atexo.signature.commun.securite.chiffrement.AESChiffrement;
import fr.atexo.signature.commun.securite.chiffrement.AbstractChiffrement;
import fr.atexo.signature.commun.securite.chiffrement.ClefIV;
import fr.atexo.signature.commun.securite.chiffrement.DonneesXML;
import fr.atexo.signature.commun.securite.chiffrement.EnveloppeXML;
import fr.atexo.signature.commun.securite.chiffrement.InfosDechiffrement;
import fr.atexo.signature.commun.securite.processor.chiffrement.ChiffrementProcessor;
import fr.atexo.signature.commun.securite.processor.chiffrement.DechiffrementProcessor;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import fr.atexo.signature.commun.securite.provider.magasin.MagasinHandler;
import fr.atexo.signature.commun.util.CertificatUtil;
import fr.atexo.signature.logging.LogManager;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class StandardChiffrementProcessor
implements ChiffrementProcessor,
DechiffrementProcessor {
    private TypeProvider typeProvider;
    private KeyPair keyPair;
    private AbstractChiffrement chiffrement;

    public StandardChiffrementProcessor(List<X509Certificate> certificats) {
        this.chiffrement = new AESChiffrement(certificats);
    }

    public StandardChiffrementProcessor(TypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public StandardChiffrementProcessor(TypeProvider typeProvider, KeyPair keyPair) {
        this(typeProvider);
        this.keyPair = keyPair;
    }

    @Override
    public byte[] chiffrer(byte[] contenu) throws ChiffrementExecutionException {
        try {
            byte[] donnees = this.chiffrement.chiffrer(contenu);
            List<ClefIV> clefIvs = this.chiffrement.getClefIVs();
            String enveloppeXML = EnveloppeXML.creerEnveloppeXml(donnees, clefIvs, contenu.length);
            return enveloppeXML.getBytes();
        }
        catch (Exception e) {
            throw new ChiffrementExecutionException("Un probl\u00e8me est survenu lors de la tentative de chiffrement du contenu d'un fichier", e);
        }
    }

    @Override
    public byte[] dechiffrer(String contenuFichierXML) throws DechiffrementExecutionException {
        DonneesXML donneesXML = null;
        try {
            donneesXML = EnveloppeXML.chargerEnveloppeXml(contenuFichierXML);
        }
        catch (Exception e) {
            throw new DechiffrementExecutionException("Un probl\u00e8me est survenu lors de la tentative de chargement de l'enveloppe xml \u00e0 d\u00e9chiffrer", e);
        }
        InfosDechiffrement infosDechiffrement = null;
        AESChiffrement chiffrementSymetrique = null;
        try {
            if (donneesXML != null) {
                chiffrementSymetrique = new AESChiffrement(null);
                infosDechiffrement = this.typeProvider != null && this.keyPair == null ? this.getInfosDechiffrementDepuisMagasin(this.typeProvider, donneesXML.getClefIVs()) : this.getInfosDechiffrementDepuisPkcs12(this.keyPair, donneesXML.getClefIVs());
            }
        }
        catch (Exception e) {
            throw new DechiffrementExecutionException("Impossible d'extraire / r\u00e9cup\u00e9rer le certificat n\u00e9cessaire au d\u00e9chiffrement de l'enveloppe xml : " + this.extraireCertificatInformations(donneesXML), e);
        }
        if (infosDechiffrement == null) {
            throw new CertificatDechiffrementIntrouvableException("Impossible de trouver le certificat n\u00e9cessaire au d\u00e9chiffrement de l'enveloppe xml : " + this.extraireCertificatInformations(donneesXML));
        }
        byte[] donnees = chiffrementSymetrique.dechiffrer(donneesXML.getDonnees(), donneesXML.getTaille(), infosDechiffrement);
        return donnees;
    }

    private String extraireCertificatInformations(DonneesXML donneesXML) {
        ArrayList<String> certificats = new ArrayList<String>();
        if (donneesXML != null) {
            for (ClefIV clefIV : donneesXML.getClefIVs()) {
                if (clefIV.getCertificat() == null) continue;
                String signataire = CertificatUtil.getCN(clefIV.getCertificat().getSubjectX500Principal());
                String emetteur = CertificatUtil.getCN(clefIV.getCertificat().getIssuerX500Principal());
                String infos = "[Signataire : " + signataire + "] | [Emetteur : " + emetteur + "]";
                certificats.add(infos);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{ ");
        for (int i = 0; i < certificats.size(); ++i) {
            String info = (String)certificats.get(i);
            stringBuilder.append(info);
            if (i == certificats.size() - 1) continue;
            stringBuilder.append(" , ");
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    private InfosDechiffrement getInfosDechiffrementDepuisMagasin(TypeProvider typeProvider, List<ClefIV> clefIVs) throws RecuperationCertificatException {
        for (ClefIV clefIV : clefIVs) {
            X509Certificate certificat = clefIV.getCertificat();
            if (certificat == null) continue;
            BigInteger serial = certificat.getSerialNumber();
            String signataire = ((Object)certificat.getSubjectDN()).toString();
            String emetteur = ((Object)certificat.getIssuerDN()).toString();
            LogManager.getInstance().afficherMessageInfo("Recherche dans le magasin de certificats du signataire " + signataire + " \u00e0 partir de son emetteur  " + emetteur + " et son serial " + serial, this.getClass());
            KeyPair keyPair = MagasinHandler.getInstance().getKeyPair(typeProvider, serial, emetteur);
            LogManager.getInstance().afficherMessageInfo("Le certificat a \u00e9t\u00e9 trouv\u00e9 dans le magasin et utilis\u00e9 pour effectuer le d\u00e9chiffrement", this.getClass());
            if (keyPair != null && keyPair.getPrivateKey() != null) {
                return new InfosDechiffrement(keyPair, clefIV);
            }
            LogManager.getInstance().afficherMessageWarning("Le certificat (couple cl\u00e9 public/cl\u00e9 priv\u00e9e) n'a pas \u00e9t\u00e9 trouv\u00e9 dans le magasin et utilis\u00e9", this.getClass());
        }
        return null;
    }

    private InfosDechiffrement getInfosDechiffrementDepuisPkcs12(KeyPair keyPair, List<ClefIV> clefIVs) {
        return new InfosDechiffrement(keyPair, clefIVs.get(0));
    }
}

