/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.processor;

import com.itextpdf.text.Rectangle;
import fr.atexo.signature.commun.exception.execution.SignatureExecutionException;
import fr.atexo.signature.commun.securite.certificat.KeyPair;
import fr.atexo.signature.commun.securite.processor.signature.ConteneurFichierSignatureXML;
import fr.atexo.signature.commun.securite.processor.signature.SignaturePadesProcessor;
import fr.atexo.signature.commun.securite.provider.TypeProvider;
import fr.atexo.signature.commun.securite.signature.SignaturePades;
import fr.atexo.signature.commun.util.CertificatUtil;
import fr.atexo.signature.commun.util.I18nUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class StandardSignaturePadesProcessor
implements SignaturePadesProcessor {
    private TypeProvider typeProvider;
    private String signatureMotif;
    private String signatureLocalisation;

    public StandardSignaturePadesProcessor() {
    }

    public StandardSignaturePadesProcessor(TypeProvider typeProvider, String signatureMotif, String signatureLocalisation) {
        this.typeProvider = typeProvider;
        this.signatureMotif = signatureMotif;
        this.signatureLocalisation = signatureLocalisation;
    }

    @Override
    public boolean signerEnPades(KeyPair keyPair, ConteneurFichierSignatureXML conteneur) throws SignatureExecutionException {
        FileInputStream fichierInputStream = null;
        File fichierDestination = null;
        FileOutputStream fichierDestinationOutputStream = null;
        try {
            fichierInputStream = new FileInputStream(conteneur.getFichier());
            fichierDestination = this.getFichierDestination(conteneur.getFichier().getPath());
            fichierDestinationOutputStream = new FileOutputStream(fichierDestination);
            PrivateKey privateKey = keyPair.getPrivateKey();
            X509Certificate certificat = keyPair.getCertificate();
            String cn = CertificatUtil.getCN(keyPair.getCertificate().getSubjectX500Principal());
            String signatureTexte = I18nUtil.get("SIGNATURE_PADES_MESSAGE_SIGNATAIRE") + " " + (cn != null ? cn : "");
            Rectangle positionSignature = new Rectangle(10.0f, 10.0f, 210.0f, 60.0f);
            SignaturePades.signerFichierPdf(fichierInputStream, fichierDestinationOutputStream, certificat, privateKey, positionSignature, this.signatureMotif, this.signatureLocalisation, signatureTexte);
            conteneur.setFichier(fichierDestination);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (fichierDestination != null && fichierDestination.exists()) {
                fichierDestination.delete();
            }
            throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la tentative de signature Pades du fichier [" + conteneur.getFichier().getPath() + "]", e);
        }
        finally {
            try {
                if (fichierInputStream != null) {
                    ((InputStream)fichierInputStream).close();
                }
            }
            catch (IOException e) {}
            try {
                if (fichierDestinationOutputStream != null) {
                    fichierDestinationOutputStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private File getFichierDestination(String cheminFichierSource) throws IOException {
        String urlFichierDisque = cheminFichierSource.substring(0, cheminFichierSource.lastIndexOf(46)) + "_signaturePades.pdf";
        File fichierDestination = new File(urlFichierDisque);
        return fichierDestination;
    }
}

