/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.processor;

import fr.atexo.json.reponse.Repertoire;
import fr.atexo.json.reponse.verification.CodeReponse;
import fr.atexo.json.reponse.verification.ReponseSignature;
import fr.atexo.signature.commun.exception.execution.SignatureExecutionException;
import fr.atexo.signature.commun.exception.execution.TransfertExecutionException;
import fr.atexo.signature.commun.securite.certificat.KeyPair;
import fr.atexo.signature.commun.securite.processor.signature.ConteneurFichierSignatureXML;
import fr.atexo.signature.commun.securite.processor.signature.ConteneurHashFichierSignatureXML;
import fr.atexo.signature.commun.securite.processor.signature.InfosComplementairesCertificat;
import fr.atexo.signature.commun.securite.processor.signature.InfosVerificationCertificat;
import fr.atexo.signature.commun.securite.processor.signature.SignatureXadesProcessor;
import fr.atexo.signature.commun.securite.signature.SignatureXades;
import fr.atexo.signature.commun.securite.signature.TypeAlgorithmHash;
import fr.atexo.signature.commun.util.Util;
import fr.atexo.signature.commun.util.io.FileUtil;
import fr.atexo.signature.commun.util.io.HashUtil;
import fr.atexo.signature.commun.util.io.XMLUtil;
import fr.atexo.signature.logging.LogManager;
import fr.atexo.signature.util.ModuleValidationUtil;
import fr.atexo.signature.util.TransfertUtil;
import fr.atexo.signature.validation.TypeEchange;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import net.iharder.Base64;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StandardSignatureXadesProcessor
implements SignatureXadesProcessor {
    private String urlModuleValidation;
    private TypeAlgorithmHash typeAlgorithmHash;
    private String originePlateforme;
    private String origineOrganisme;
    private String origineItem;
    private String origineContexteMetier;
    private String cheminFichierSignatureXML;
    private String contenuFichierSignatureXML;
    private File fichierSignatureXML;

    public StandardSignatureXadesProcessor(String urlModuleValidation, TypeAlgorithmHash typeAlgorithmHash) {
        this.urlModuleValidation = urlModuleValidation;
        this.typeAlgorithmHash = typeAlgorithmHash;
    }

    public void ajouterInformationsPourModuleValidation(String originePlateforme, String origineOrganisme, String origineItem, String origineContexteMetier) {
        this.originePlateforme = originePlateforme;
        this.origineOrganisme = origineOrganisme;
        this.origineItem = origineItem;
        this.origineContexteMetier = origineContexteMetier;
    }

    @Override
    public InfosComplementairesCertificat signerEnXades(KeyPair keyPair, ConteneurHashFichierSignatureXML conteneur) throws SignatureExecutionException {
        return this.signerEnXades(keyPair, null, conteneur);
    }

    @Override
    public InfosComplementairesCertificat signerEnXades(KeyPair keyPair, ConteneurFichierSignatureXML conteneur) throws SignatureExecutionException {
        return this.signerEnXades(keyPair, conteneur, null);
    }

    private InfosComplementairesCertificat signerEnXades(KeyPair keyPair, ConteneurFichierSignatureXML conteneurFichierSignatureXML, ConteneurHashFichierSignatureXML conteneurHashFichierSignatureXML) throws SignatureExecutionException {
        boolean estFichier = conteneurFichierSignatureXML != null;
        String signatureXadesServeurEnBase64 = null;
        byte[] hashBinaireFichier = null;
        URI uriFichier = null;
        try {
            uriFichier = estFichier ? conteneurFichierSignatureXML.getFichier().toURI() : null;
            hashBinaireFichier = estFichier ? HashUtil.genererHashShaBinaire(this.typeAlgorithmHash, conteneurFichierSignatureXML.getFichier()) : HashUtil.convertirHexadecimalEnBinaire(conteneurHashFichierSignatureXML.getHashFichier());
        }
        catch (IOException e) {
            throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la g\u00e9n\u00e9ration du hash du fichier : " + conteneurFichierSignatureXML.getFichier().getPath(), e);
        }
        Date dateSignature = null;
        if (!Util.estVide(this.urlModuleValidation)) {
            try {
                String reponseJson = TransfertUtil.recupererDateModuleValidation(this.urlModuleValidation);
                if (!Util.estVide(reponseJson)) {
                    Date dateISO8601 = this.getDateServeur(reponseJson);
                    if (dateISO8601 == null) {
                        LogManager.getInstance().afficherMessageWarning("Impossible de r\u00e9cup\u00e9rer la date de signature depuis le serveur => la date de signature est une date de signature g\u00e9n\u00e9r\u00e9e c\u00f4t\u00e9 client", this.getClass());
                        dateISO8601 = new Date();
                    }
                    dateSignature = dateISO8601;
                }
            }
            catch (TransfertExecutionException e) {
                LogManager.getInstance().afficherMessageWarning(e.getMessage(), e, this.getClass());
            }
        } else {
            LogManager.getInstance().afficherMessageInfo("Aucune url de module de validation param\u00e9tr\u00e9 => la date de signature est une date de signature g\u00e9n\u00e9r\u00e9e c\u00f4t\u00e9 client", this.getClass());
            dateSignature = new Date();
        }
        LogManager.getInstance().afficherMessageInfo("Date de signature : " + dateSignature, this.getClass());
        String signatureXadesFinale = null;
        try {
            signatureXadesFinale = SignatureXades.signer(keyPair, hashBinaireFichier, uriFichier, dateSignature, this.typeAlgorithmHash);
        }
        catch (Exception e) {
            String message = "Un probl\u00e8me est survenu lors de la tentative de cr\u00e9ation de la signature XAdES" + (estFichier ? " du fichier " + conteneurFichierSignatureXML.getFichier() : " du hash de fichier " + conteneurHashFichierSignatureXML.getHashFichier());
            throw new SignatureExecutionException(message, e);
        }
        Boolean dateSignatureValide = null;
        Boolean periodiciteValide = null;
        Boolean absenceRevocationCRL = null;
        Boolean chaineDeCertificationValide = null;
        Set<Repertoire> repertoiresChaineCertification = null;
        Set<Repertoire> repertoiresChaineRevocation = null;
        String reponseModuleValidationJson = null;
        if (!Util.estVide(this.urlModuleValidation)) {
            ReponseSignature reponseSignature;
            try {
                reponseModuleValidationJson = TransfertUtil.envoyerAuModuleValidation(this.urlModuleValidation, Base64.encodeBytes(signatureXadesFinale.getBytes("UTF-8")), TypeEchange.EnrichissementSignature, this.typeAlgorithmHash, this.originePlateforme, this.origineOrganisme, this.origineItem, this.origineContexteMetier);
            }
            catch (Exception e) {
                throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la tentative d'acc\u00e8s au module de validation de signature", e);
            }
            if (!Util.estVide(reponseModuleValidationJson)) {
                reponseSignature = this.getReponseSignature(reponseModuleValidationJson, true);
                if (reponseSignature == null || reponseSignature.getCodeRetour().intValue() != CodeReponse.Ok.getCode()) {
                    throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la tentative d'acc\u00e8s au module de validation de signature" + reponseSignature.getMessage());
                }
            } else {
                throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la tentative d'acc\u00e8s au module de validation de signature");
            }
            dateSignatureValide = reponseSignature.getDateSignatureValide();
            periodiciteValide = reponseSignature.getPeriodiciteValide();
            chaineDeCertificationValide = reponseSignature.getChaineDeCertificationValide();
            absenceRevocationCRL = reponseSignature.getAbsenceRevocationCRL();
            repertoiresChaineCertification = reponseSignature.getRepertoiresChaineCertification();
            repertoiresChaineRevocation = reponseSignature.getRepertoiresRevocation();
            signatureXadesServeurEnBase64 = reponseSignature.getSignatureXadesServeurEnBase64();
            try {
                signatureXadesFinale = new String(Base64.decode(signatureXadesServeurEnBase64.getBytes("UTF-8")), "UTF-8");
            }
            catch (IOException e) {
                throw new SignatureExecutionException("Un probl\u00e8me est survenu lors du d\u00e9code en base 64 du contenu de la signature enrichi par le module de validation ", e);
            }
        }
        InfosComplementairesCertificat resultatVerificationSignature = estFichier ? this.verifierConformite(conteneurFichierSignatureXML.getFichier(), signatureXadesFinale, false) : this.verifierConformite(conteneurHashFichierSignatureXML.getHashFichier().getBytes(), signatureXadesFinale);
        resultatVerificationSignature.setDateSignatureValide(dateSignatureValide);
        resultatVerificationSignature.setPeriodiciteValide(periodiciteValide);
        resultatVerificationSignature.setAbsenceRevocationCRL(absenceRevocationCRL);
        resultatVerificationSignature.setChaineDeCertificationValide(chaineDeCertificationValide);
        resultatVerificationSignature.setRepertoiresChaineCertification(repertoiresChaineCertification);
        resultatVerificationSignature.setRepertoiresRevocation(repertoiresChaineRevocation);
        if (resultatVerificationSignature != null) {
            if (estFichier) {
                int indexFichier = FileUtil.getProchaineIndexFichierSignatureXML(conteneurFichierSignatureXML.getFichier().getPath());
                String formatDateNomFichier = Util.formaterDate(dateSignature, "yyyyMMddHHmmss");
                this.cheminFichierSignatureXML = XMLUtil.contruireCheminFichierSignatureXML(conteneurFichierSignatureXML.getFichier().getPath(), formatDateNomFichier, indexFichier);
                this.fichierSignatureXML = new File(this.cheminFichierSignatureXML);
                this.contenuFichierSignatureXML = signatureXadesFinale;
                try {
                    FileUtils.writeStringToFile(this.fichierSignatureXML, signatureXadesFinale, "UTF-8");
                }
                catch (IOException e) {
                    throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de l'enregistrement sur le disque du fichier de signature XML : " + this.cheminFichierSignatureXML, e);
                }
                boolean fichierExistant = this.fichierSignatureXML.exists();
                if (fichierExistant) {
                    conteneurFichierSignatureXML.setFichierSignatureXml(this.fichierSignatureXML);
                }
            } else {
                conteneurHashFichierSignatureXML.setContenuSignatureXml(Base64.encodeBytes(signatureXadesFinale.getBytes()));
            }
            return resultatVerificationSignature;
        }
        return null;
    }

    @Override
    public InfosComplementairesCertificat verifierConformite(byte[] hashFichier, String contenuFichierSignatureXML) throws SignatureExecutionException {
        try {
            ArrayList<String> hashFichiers = new ArrayList<String>();
            hashFichiers.add(new String(hashFichier));
            InfosVerificationCertificat resultatVerificationSignature = SignatureXades.verifier(contenuFichierSignatureXML, hashFichiers);
            return resultatVerificationSignature;
        }
        catch (Exception e) {
            throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la v\u00e9rification du hash du fichier [" + hashFichier + "] avec son fichier de signature XML associ\u00e9", e);
        }
    }

    @Override
    public InfosComplementairesCertificat verifierConformite(File fichier, String contenuFichierSignatureXML, boolean utiliserModuleValidation) throws SignatureExecutionException {
        try {
            InfosVerificationCertificat resultatVerificationSignature = SignatureXades.verifier(contenuFichierSignatureXML, fichier);
            if (utiliserModuleValidation && !Util.estVide(this.urlModuleValidation)) {
                String reponseModuleValidationJson = null;
                try {
                    reponseModuleValidationJson = TransfertUtil.envoyerAuModuleValidation(this.urlModuleValidation, Base64.encodeBytes(contenuFichierSignatureXML.getBytes("UTF-8")), TypeEchange.VerificationSignatureClient, this.typeAlgorithmHash, this.originePlateforme, this.origineOrganisme, this.origineItem, this.origineContexteMetier);
                }
                catch (Exception e) {
                    throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la tentative d'acc\u00e8s au module de validation de signature", e);
                }
                if (!Util.estVide(reponseModuleValidationJson)) {
                    ReponseSignature reponseSignature = this.getReponseSignature(reponseModuleValidationJson, false);
                    if (reponseSignature.getCodeRetour().intValue() != CodeReponse.Ok.getCode()) {
                        throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la tentative d'acc\u00e8s au module de validation de signature : " + reponseSignature.getMessage());
                    }
                    resultatVerificationSignature.setDateSignatureValide(reponseSignature.getDateSignatureValide());
                    resultatVerificationSignature.setPeriodiciteValide(reponseSignature.getPeriodiciteValide());
                    resultatVerificationSignature.setChaineDeCertificationValide(reponseSignature.getChaineDeCertificationValide());
                    resultatVerificationSignature.setAbsenceRevocationCRL(reponseSignature.getAbsenceRevocationCRL());
                    resultatVerificationSignature.setRepertoiresChaineCertification(reponseSignature.getRepertoiresChaineCertification());
                    resultatVerificationSignature.setRepertoiresRevocation(reponseSignature.getRepertoiresRevocation());
                } else {
                    throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la tentative d'acc\u00e8s au module de validation de signature");
                }
            }
            return resultatVerificationSignature;
        }
        catch (Exception e) {
            throw new SignatureExecutionException("Un probl\u00e8me est survenu lors de la v\u00e9rification du fichier [" + fichier.getPath() + "] avec son fichier de signature XML associ\u00e9", e);
        }
    }

    public ReponseSignature getReponseSignature(String reponseJson, boolean signature) {
        ReponseSignature reponseSignature = null;
        try {
            JSONObject reponseModuleValidationJsonObject = new JSONObject(reponseJson);
            String message = reponseModuleValidationJsonObject.getString("message");
            Integer codeRetour = reponseModuleValidationJsonObject.getInt("codeRetour");
            reponseSignature = new ReponseSignature(codeRetour, message);
            if (codeRetour.intValue() == CodeReponse.Ok.getCode()) {
                int i;
                JSONArray repertoires;
                String dateSignatureValide = reponseModuleValidationJsonObject.getString("dateSignatureValide");
                if (dateSignatureValide != null) {
                    reponseSignature.setDateSignatureValide(Boolean.valueOf(dateSignatureValide));
                }
                JSONObject reponseRetourVerificationJsonObject = reponseModuleValidationJsonObject.getJSONObject("resultat");
                Integer codeRetourPeriodeValidite = reponseRetourVerificationJsonObject.getInt("periodeValidite");
                Boolean periodiciteValide = ModuleValidationUtil.getEtatValidite(codeRetourPeriodeValidite);
                reponseSignature.setPeriodiciteValide(periodiciteValide);
                Integer codeRetourChaineCertification = reponseRetourVerificationJsonObject.getInt("chaineCertification");
                Boolean chaineDeCertificationValide = ModuleValidationUtil.getEtatCertificat(codeRetourChaineCertification);
                reponseSignature.setChaineDeCertificationValide(chaineDeCertificationValide);
                Integer codeRetourRevocation = reponseRetourVerificationJsonObject.getInt("revocation");
                Boolean absenceRevocationCRL = ModuleValidationUtil.getEtatCertificat(codeRetourRevocation);
                reponseSignature.setAbsenceRevocationCRL(absenceRevocationCRL);
                if (signature && reponseModuleValidationJsonObject.has("contenuFichierXMLEnBase64")) {
                    String signatureXadesServeurEnBase64 = reponseModuleValidationJsonObject.getString("contenuFichierXMLEnBase64");
                    reponseSignature.setSignatureXadesServeurEnBase64(signatureXadesServeurEnBase64);
                }
                if (reponseRetourVerificationJsonObject.has("repertoiresChaineCertification")) {
                    repertoires = reponseRetourVerificationJsonObject.getJSONArray("repertoiresChaineCertification");
                    for (i = 0; i < repertoires.length(); ++i) {
                        JSONObject repertoireChaineCertification = repertoires.getJSONObject(i);
                        if (repertoireChaineCertification == null || !repertoireChaineCertification.has("nom")) continue;
                        reponseSignature.ajouterRepertoireChaineCertification(repertoireChaineCertification.getString("nom"));
                    }
                }
                if (reponseRetourVerificationJsonObject.has("repertoiresRevocation")) {
                    repertoires = reponseRetourVerificationJsonObject.getJSONArray("repertoiresRevocation");
                    for (i = 0; i < repertoires.length(); ++i) {
                        JSONObject repertoireRevocation = repertoires.getJSONObject(i);
                        if (repertoireRevocation == null || !repertoireRevocation.has("nom")) continue;
                        reponseSignature.ajouterRepertoireRevocation(repertoireRevocation.getString("nom"));
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return reponseSignature;
    }

    public Date getDateServeur(String reponseJson) {
        Date dateServeur = null;
        try {
            String dateISO8601;
            JSONObject reponseModuleValidationJsonObject = new JSONObject(reponseJson);
            Integer codeRetour = reponseModuleValidationJsonObject.getInt("codeRetour");
            if (codeRetour.intValue() == CodeReponse.Ok.getCode() && (dateISO8601 = reponseModuleValidationJsonObject.getString("dateISO8601")) != null) {
                dateServeur = Util.convertirISO8601DateTime(dateISO8601);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return dateServeur;
    }

    public File getFichierSignatureXML() {
        return this.fichierSignatureXML;
    }

    public String getCheminFichierSignatureXML() {
        return this.cheminFichierSignatureXML;
    }

    public String getContenuFichierSignatureXML() {
        return this.contenuFichierSignatureXML;
    }
}

