/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.util;

import fr.atexo.signature.commun.util.I18nUtil;
import fr.atexo.signature.commun.util.JaxbReponsesAnnonceUtil;
import fr.atexo.signature.commun.util.Util;
import java.io.File;
import java.util.List;

public abstract class AffichageUtil {
    public static String getTypeEnvNomRepertoire(int typeEnveloppe, int numeroLot) {
        if (typeEnveloppe == 1) {
            return "Candidature";
        }
        if (typeEnveloppe == 2 && numeroLot == 0) {
            return "Offre";
        }
        if (typeEnveloppe == 2 && numeroLot > 0) {
            return "Offre_Lot_" + numeroLot;
        }
        if (typeEnveloppe == 3 && numeroLot == 0) {
            return "Anonymat";
        }
        if (typeEnveloppe == 3 && numeroLot > 0) {
            return "Anonymat_Lot_" + numeroLot;
        }
        if (typeEnveloppe == 4 && numeroLot == 0) {
            return "OffreTechnique";
        }
        if (typeEnveloppe == 4 && numeroLot > 0) {
            return "OffreTechnique_Lot" + numeroLot;
        }
        return "Indetermine";
    }

    public static String getMessageTypeEnveloppeEtNumeroLot(JaxbReponsesAnnonceUtil.FichierBloc fichierBloc) {
        return AffichageUtil.getMessageTypeEnveloppeEtNumeroLot(fichierBloc.getTypeEnveloppe(), fichierBloc.getNumeroLot());
    }

    public static String getMessageTypeEnveloppeEtNumeroLot(int typeEnveloppe, int numeroLot) {
        if (typeEnveloppe == 1) {
            return I18nUtil.get("ENVELOPPE_CANDIDATURE");
        }
        if (typeEnveloppe == 2 && numeroLot == 0) {
            return I18nUtil.get("ENVELOPPE_OFFRE");
        }
        if (typeEnveloppe == 2 && numeroLot > 0) {
            return I18nUtil.get("ENVELOPPE_OFFRE") + " " + I18nUtil.get("LOT") + " " + numeroLot;
        }
        if (typeEnveloppe == 3 && numeroLot == 0) {
            return I18nUtil.get("ENVELOPPE_ANONYMAT");
        }
        if (typeEnveloppe == 3 && numeroLot > 0) {
            return I18nUtil.get("ENVELOPPE_ANONYMAT") + " " + I18nUtil.get("LOT") + " " + numeroLot;
        }
        return "";
    }

    public static String getMessageTailleFichier(File file) {
        return AffichageUtil.getMessageTaille(file.length());
    }

    public static String getMessageTailleTexte(String texte) {
        return AffichageUtil.getMessageTaille(texte.length());
    }

    public static String getMessageTailleFichier(List<File> fichiers) {
        long tailleTotale = 0L;
        for (File fichier : fichiers) {
            tailleTotale += fichier.length();
        }
        return AffichageUtil.getMessageTaille(tailleTotale);
    }

    public static String getMessageTaille(long taille) {
        int unKiloOctet = 1024;
        if (taille < 1000L) {
            return taille + " " + I18nUtil.get("OCTETS");
        }
        if (taille < 1000000L) {
            long ko = taille / 1024L;
            return Util.arrondir(ko, 2) + " " + I18nUtil.get("ABBR_KILO_OCTETS");
        }
        if (taille < 1000000000L) {
            long mo = taille / 0x100000L;
            return Util.arrondir(mo, 2) + " " + I18nUtil.get("ABBR_MEGA_OCTETS");
        }
        long go = taille / 0x40000000L;
        return Util.arrondir(go, 2) + " " + I18nUtil.get("ABBR_GIGA_OCTETS");
    }
}

