/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.util;

import fr.atexo.signature.commun.securite.provider.TypeOs;
import fr.atexo.signature.commun.securite.provider.pkcs11.smartcard.SmartCardInformation;
import fr.atexo.signature.util.SmartCardInformationBean;
import fr.atexo.signature.xml.pkcs11.LibType;
import fr.atexo.signature.xml.pkcs11.LibsType;
import fr.atexo.signature.xml.pkcs11.Pkcs11LibType;
import fr.atexo.signature.xml.pkcs11.Pkcs11LibsType;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SmartCardUtil {
    public static List<SmartCardInformation> getSmartCardInformations(Pkcs11LibsType pkcs11Libs, TypeOs typeOs) {
        ArrayList<SmartCardInformation> smartCardInformations = new ArrayList<SmartCardInformation>();
        for (Pkcs11LibType pkcs11Lib : pkcs11Libs.getPkcs11Lib()) {
            LibsType libsType = null;
            switch (typeOs) {
                case Windows: {
                    libsType = pkcs11Lib.getLibsWindows();
                    break;
                }
                case MacOs: {
                    libsType = pkcs11Lib.getLibsMacOs();
                    break;
                }
                case Linux: {
                    libsType = pkcs11Lib.getLibsLinux();
                }
            }
            try {
                if (libsType == null) continue;
                for (LibType libType : libsType.getLib()) {
                    File fichierLib;
                    if (libType.getChemin() == null || (fichierLib = new File(libType.getChemin())) == null || !fichierLib.exists()) continue;
                    SmartCardInformationBean smartCardInformationBean = SmartCardUtil.genererSmartCardInformationBean(null, fichierLib, pkcs11Lib.getFournisseur());
                    smartCardInformations.add(smartCardInformationBean);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return smartCardInformations;
    }

    public static Map<String, List<File>> getPkcs11Providers(Pkcs11LibsType pkcs11Libs, TypeOs typeOs) {
        HashMap<String, List<File>> mapProviders = new HashMap<String, List<File>>();
        for (Pkcs11LibType pkcs11Lib : pkcs11Libs.getPkcs11Lib()) {
            LibsType libsType = null;
            switch (typeOs) {
                case Windows: {
                    libsType = pkcs11Lib.getLibsWindows();
                    break;
                }
                case MacOs: {
                    libsType = pkcs11Lib.getLibsMacOs();
                    break;
                }
                case Linux: {
                    libsType = pkcs11Lib.getLibsLinux();
                }
            }
            if (libsType == null) continue;
            for (LibType libType : libsType.getLib()) {
                File fichierLib;
                if (libType.getChemin() == null || (fichierLib = new File(libType.getChemin())) == null || !fichierLib.exists()) continue;
                ArrayList<File> fichiers = (ArrayList<File>)mapProviders.get(pkcs11Lib.getFournisseur());
                if (fichiers == null) {
                    fichiers = new ArrayList<File>();
                }
                fichiers.add(fichierLib);
                mapProviders.put(pkcs11Lib.getFournisseur(), fichiers);
            }
        }
        return mapProviders;
    }

    private static SmartCardInformationBean genererSmartCardInformationBean(String atr, File librairie, String nomFabriquant) {
        SmartCardInformationBean smartCardInformationBean = new SmartCardInformationBean();
        smartCardInformationBean.setAtr(atr);
        smartCardInformationBean.setLibrairie(librairie);
        smartCardInformationBean.setNomFabriquant(nomFabriquant);
        return smartCardInformationBean;
    }
}

