/*
 * Decompiled with CFR 0.152.
 */
package fr.atexo.signature.util;

import fr.atexo.signature.commun.exception.execution.TransfertExecutionException;
import fr.atexo.signature.commun.securite.signature.TypeAlgorithmHash;
import fr.atexo.signature.commun.util.Util;
import fr.atexo.signature.http.HttpRequest;
import fr.atexo.signature.validation.TypeEchange;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public abstract class TransfertUtil {
    public static final String RESULTAT_RETOUR_UPLOAD_VALIDE = "OK";
    public static final String RESULTAT_RETOUR_UPLOAD_INVALIDE = "NOK";
    public static final String CONTENU_FICHIER_XML = "contenuFichierXML";
    public static final String TYPE_ECHANGE = "typeEchange";
    public static final String TYPE_ALGORITHM_HASH = "typeAlgorithmHash";
    public static final String HASH_FICHIER = "hashFichier";
    public static final String ORIGINE_PLATEFORME = "plateforme";
    public static final String ORIGINE_ORGANISME = "organisme";
    public static final String ORIGINE_ITEM = "item";
    public static final String ORIGINE_CONTEXTE_METIER = "contexteMetier";

    public static String recupererDateModuleValidation(String urlModuleValidation) throws TransfertExecutionException {
        try {
            HttpRequest httpRequest = new HttpRequest(new URL(urlModuleValidation), true);
            httpRequest.ajouterContenu(TYPE_ECHANGE, TypeEchange.RetourDateServeur.name());
            InputStream inputStream = httpRequest.envoyer();
            String reponseJson = IOUtils.toString(inputStream);
            inputStream.close();
            httpRequest.deconnecter();
            return reponseJson;
        }
        catch (Exception e) {
            throw new TransfertExecutionException("Erreur lors de la date serveur depuis le module validation", e);
        }
    }

    public static String envoyerAuModuleValidation(String urlModuleValidation, String signatureXadesClientEnBase64, TypeEchange typeEchange, TypeAlgorithmHash typeAlgorithmHash, String originePlateforme, String origineOrganisme, String origineItem, String origineContexteMetier) throws TransfertExecutionException {
        try {
            HttpRequest httpRequest = new HttpRequest(new URL(urlModuleValidation), true);
            httpRequest.ajouterContenu(CONTENU_FICHIER_XML, signatureXadesClientEnBase64);
            httpRequest.ajouterContenu(TYPE_ECHANGE, typeEchange.name());
            httpRequest.ajouterContenu(TYPE_ALGORITHM_HASH, typeAlgorithmHash.name());
            if (!Util.estVide(originePlateforme)) {
                httpRequest.ajouterContenu(ORIGINE_PLATEFORME, originePlateforme);
            }
            if (!Util.estVide(origineOrganisme)) {
                httpRequest.ajouterContenu(ORIGINE_ORGANISME, origineOrganisme);
            }
            if (!Util.estVide(origineItem)) {
                httpRequest.ajouterContenu(ORIGINE_ITEM, origineItem);
            }
            if (!Util.estVide(origineContexteMetier)) {
                httpRequest.ajouterContenu(ORIGINE_CONTEXTE_METIER, origineContexteMetier);
            }
            InputStream inputStream = httpRequest.envoyer();
            String resultat = IOUtils.toString(inputStream);
            inputStream.close();
            httpRequest.deconnecter();
            return resultat;
        }
        catch (Exception e) {
            throw new TransfertExecutionException("Erreur lors du transfert des donn\u00e9es de signature XML au serveur de validation", e);
        }
    }

    public static String envoyerBlocChiffre(String urlServeurUpload, String uid, int typeEnveloppe, int numeroLot, String nomfichier, String typeFichier, int indexFichier, int numeroBlocFichier, String blocChiffrement) throws TransfertExecutionException {
        try {
            HttpRequest httpRequest = new HttpRequest(new URL(urlServeurUpload), true);
            if (blocChiffrement != null) {
                httpRequest.ajouterContenu("uidOffre", uid);
                httpRequest.ajouterContenu("typeEnv", typeEnveloppe);
                httpRequest.ajouterContenu("sousPli", numeroLot);
                httpRequest.ajouterContenu("typeFichier", typeFichier);
                httpRequest.ajouterContenu("numOrdreFichier", indexFichier);
                httpRequest.ajouterContenu("numOrdreBloc", numeroBlocFichier);
                httpRequest.ajouterContenu("bloc", blocChiffrement);
            }
            InputStream inputStream = httpRequest.envoyer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            String resultat = reader.readLine();
            reader.close();
            httpRequest.deconnecter();
            return resultat;
        }
        catch (Exception e) {
            throw new TransfertExecutionException("Erreur lors de l'envoi \u00e0 l'url [" + urlServeurUpload + "] du contenu du bloc num\u00e9ro [" + numeroBlocFichier + "] pour le fichier [" + nomfichier + "] de type [" + typeFichier + "] pour le type d'enveloppe [" + typeEnveloppe + "] et num\u00e9ro de lot [" + numeroLot + "]", e);
        }
    }

    public static String envoyerBloc(String urlServeurUpload, String trigrammeOrganisme, String idBlocDeChiffrement, String contenuDechiffreBase64) throws TransfertExecutionException {
        try {
            return TransfertUtil.envoyerInformations(urlServeurUpload, trigrammeOrganisme, null, idBlocDeChiffrement, contenuDechiffreBase64, TypeTransfert.TransfertBloc);
        }
        catch (Exception e) {
            throw new TransfertExecutionException("Erreur lors de l'envoi \u00e0 l'url [" + urlServeurUpload + "] du contenu du bloc d\u00e9chiffr\u00e9 ayant identifiant [" + idBlocDeChiffrement + "] pour l'organisme ayant comme trigramme [" + trigrammeOrganisme + "]", e);
        }
    }

    @Deprecated
    public static String envoyerInformationsFinTraitementDechiffrement(String urlServeurUpload, String trigrammeOrganisme, String idPremierBlocDeChiffrement) throws TransfertExecutionException {
        try {
            return TransfertUtil.envoyerInformations(urlServeurUpload, trigrammeOrganisme, null, idPremierBlocDeChiffrement, null, TypeTransfert.OuvertureEnLigne);
        }
        catch (Exception e) {
            throw new TransfertExecutionException("Erreur lors de l'envoi \u00e0 l'url [" + urlServeurUpload + "]  des informations sp\u00e9ficiant la fin du traitement de l'ensemble des bloc dont le premier \u00e9tait  [" + idPremierBlocDeChiffrement + "] pour l'organisme ayant comme trigramme [" + trigrammeOrganisme + "]", e);
        }
    }

    public static String envoyerInformationsOuvertureEnveloppe(String urlServeurUpload, String trigrammeOrganisme, String idEnveloppe, TypeTransfert typeTransfert) throws TransfertExecutionException {
        try {
            return TransfertUtil.envoyerInformations(urlServeurUpload, trigrammeOrganisme, idEnveloppe, null, null, typeTransfert);
        }
        catch (Exception e) {
            throw new TransfertExecutionException("Erreur lors de l'envoi \u00e0 l'url [" + urlServeurUpload + "]  des informations sp\u00e9ficiant l'ouverture de l'enveloppe ayant comme identifiant [" + idEnveloppe + "] pour l'organisme ayant comme trigramme [" + trigrammeOrganisme + "]", e);
        }
    }

    public static String envoyerInformations(String urlServeurUpload, String trigrammeOrganisme, String idEnveloppe, String idBlocDeChiffrement, String contenuDechiffreBase64, TypeTransfert typeTransfert) throws Exception {
        HttpRequest httpRequest = new HttpRequest(new URL(urlServeurUpload), true);
        if (idBlocDeChiffrement != null) {
            httpRequest.ajouterContenu("idBlob", idBlocDeChiffrement);
        }
        if (trigrammeOrganisme != null) {
            httpRequest.ajouterContenu(ORIGINE_ORGANISME, trigrammeOrganisme);
        }
        if (typeTransfert == TypeTransfert.TransfertBloc) {
            httpRequest.ajouterContenu("blocDechiffre", contenuDechiffreBase64);
        } else {
            httpRequest.ajouterContenu("endDecrypt", typeTransfert.getValeur());
        }
        if (idEnveloppe != null) {
            httpRequest.ajouterContenu("idEnveloppe", idEnveloppe);
        }
        InputStream inputStream = httpRequest.envoyer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String resultat = reader.readLine();
        reader.close();
        httpRequest.deconnecter();
        return resultat;
    }

    public static String contruireUrlTelechargement(String urlServeurTelechargement, String trigrammeOrganisme, String idBlocDeChiffrement) throws TransfertExecutionException {
        boolean verificationUrl = urlServeurTelechargement.contains("?");
        String url = urlServeurTelechargement + (verificationUrl ? "&" : "?") + "organisme=" + trigrammeOrganisme + "&idBlob=" + idBlocDeChiffrement;
        return url;
    }

    public static byte[] telechargerBloc(String urlServeurTelechargement, String trigrammeOrganisme, String idBlocDeChiffrement) throws TransfertExecutionException {
        byte[] byArray;
        InputStream inputStream;
        ByteArrayOutputStream outputStream;
        block5: {
            HttpRequest httpRequest = null;
            outputStream = null;
            inputStream = null;
            try {
                byte[] contenuBlocDeChiffrement;
                boolean verificationUrl = urlServeurTelechargement.contains("?");
                String url = urlServeurTelechargement + (verificationUrl ? "&" : "?") + "organisme=" + trigrammeOrganisme + "&idBlob=" + idBlocDeChiffrement;
                httpRequest = new HttpRequest(new URL(url), false);
                inputStream = httpRequest.getInputStream();
                outputStream = new ByteArrayOutputStream();
                IOUtils.copy(inputStream, (OutputStream)outputStream);
                byArray = contenuBlocDeChiffrement = outputStream.toByteArray();
                if (httpRequest == null) break block5;
                httpRequest.deconnecter();
            }
            catch (Exception e) {
                try {
                    throw new TransfertExecutionException("Erreur lors de la r\u00e9cup\u00e9ration des donn\u00e9es du bloc de chiffrement id " + idBlocDeChiffrement + "  et organisme " + trigrammeOrganisme, e);
                }
                catch (Throwable throwable) {
                    if (httpRequest != null) {
                        httpRequest.deconnecter();
                    }
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(inputStream);
        IOUtils.closeQuietly(outputStream);
        return byArray;
    }

    public static byte[] telecharger(String urlServeurTelechargement) throws TransfertExecutionException {
        ByteArrayOutputStream outputStream = null;
        try {
            byte[] contenuBlocDeChiffrement;
            outputStream = TransfertUtil.telechargerStream(urlServeurTelechargement);
            byte[] byArray = contenuBlocDeChiffrement = outputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new TransfertExecutionException("Erreur lors de la r\u00e9cup\u00e9ration des donn\u00e9es via l'url [" + urlServeurTelechargement + "]", e);
        }
        finally {
            IOUtils.closeQuietly(outputStream);
        }
    }

    public static ByteArrayOutputStream telechargerStream(String urlServeurTelechargement) throws TransfertExecutionException {
        ByteArrayOutputStream byteArrayOutputStream;
        InputStream inputStream;
        block5: {
            HttpRequest httpRequest = null;
            ByteArrayOutputStream outputStream = null;
            inputStream = null;
            try {
                httpRequest = new HttpRequest(new URL(urlServeurTelechargement), false);
                inputStream = httpRequest.getInputStream();
                outputStream = new ByteArrayOutputStream();
                IOUtils.copy(inputStream, (OutputStream)outputStream);
                byteArrayOutputStream = outputStream;
                if (httpRequest == null) break block5;
                httpRequest.deconnecter();
            }
            catch (Exception e) {
                try {
                    throw new TransfertExecutionException("Erreur lors de la r\u00e9cup\u00e9ration des donn\u00e9es via l'url [" + urlServeurTelechargement + "]", e);
                }
                catch (Throwable throwable) {
                    if (httpRequest != null) {
                        httpRequest.deconnecter();
                    }
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly(inputStream);
        return byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifierUrl(String url) {
        HttpURLConnection connection = null;
        try {
            connection = new HttpRequest(new URL(url), false).getConnection();
            connection.connect();
            boolean bl = connection.getResponseCode() == 200;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static enum TypeTransfert {
        TransfertBloc("0"),
        OuvertureEnLigne("1"),
        OuvertureMixte("2");

        private String valeur;

        private TypeTransfert(String valeur) {
            this.valeur = valeur;
        }

        public String getValeur() {
            return this.valeur;
        }
    }
}

