/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

@Deprecated
public class AtexoCMSSignedDataGenerator
extends CMSSignedGenerator {
    List signerInfs = new ArrayList();

    public AtexoCMSSignedDataGenerator() {
    }

    public AtexoCMSSignedDataGenerator(SecureRandom rand) {
        super(rand);
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, new DefaultSignedAttributeTableGenerator(signedAttr), new SimpleAttributeTableGenerator(unsignedAttr), signedAttr));
    }

    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, CMSAttributeTableGenerator signedAttrGen, CMSAttributeTableGenerator unsignedAttrGen) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.signerInfs.add(new SignerInf(key, cert, digestOID, encOID, signedAttrGen, unsignedAttrGen, null));
    }

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        return aIn.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), this.makeObj(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), new DERNull());
    }

    public CMSSignedData generate(CMSProcessable content, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, false, sigProvider);
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(signedContentType, content, encapsulate, sigProvider, true);
    }

    public CMSSignedData generate(String signedContentType, byte[] hash, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(signedContentType, hash, encapsulate, sigProvider, true);
    }

    public CMSSignedData generate(byte[] hash, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, hash, encapsulate, sigProvider);
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, Provider sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        ContentInfo encInfo;
        boolean isCounterSignature;
        ASN1ObjectIdentifier contentTypeOID;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            AlgorithmIdentifier digAlgId;
            try {
                digAlgId = this.makeAlgId(signer.getDigestAlgOID(), signer.getDigestAlgParams());
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            digestAlgs.add(digAlgId);
            signerInfos.add(signer.toSignerInfo());
        }
        if (signedContentType != null) {
            contentTypeOID = new ASN1ObjectIdentifier(signedContentType);
            isCounterSignature = false;
        } else {
            contentTypeOID = CMSObjectIdentifiers.data;
            isCounterSignature = true;
        }
        for (SignerInf signer : this.signerInfs) {
            try {
                AlgorithmIdentifier digAlgId = this.makeAlgId(signer.getDigestAlgOID(), signer.getDigestAlgParams());
                digestAlgs.add(digAlgId);
                signerInfos.add(signer.toSignerInfo((DERObjectIdentifier)contentTypeOID, content, this.rand, sigProvider, addDefaultAttributes, isCounterSignature));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for signature.", e);
            }
            catch (SignatureException e) {
                throw new CMSException("error creating signature.", e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", e);
            }
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                content.write(bOut);
            }
            catch (IOException e) {
                throw new CMSException("encapsulation error.", e);
            }
            BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
            encInfo = new ContentInfo(contentTypeOID, octs);
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, sd);
        return new CMSSignedData(content, contentInfo);
    }

    public CMSSignedData generate(String signedContentType, byte[] hash, boolean encapsulate, Provider sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        boolean isCounterSignature;
        ASN1ObjectIdentifier contentTypeOID;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signer : this._signers) {
            AlgorithmIdentifier digAlgId;
            try {
                digAlgId = this.makeAlgId(signer.getDigestAlgOID(), signer.getDigestAlgParams());
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            digestAlgs.add(digAlgId);
            signerInfos.add(signer.toSignerInfo());
        }
        if (signedContentType != null) {
            contentTypeOID = new ASN1ObjectIdentifier(signedContentType);
            isCounterSignature = false;
        } else {
            contentTypeOID = CMSObjectIdentifiers.data;
            isCounterSignature = true;
        }
        for (SignerInf signer : this.signerInfs) {
            try {
                AlgorithmIdentifier digAlgId = this.makeAlgId(signer.getDigestAlgOID(), signer.getDigestAlgParams());
                digestAlgs.add(digAlgId);
                signerInfos.add(signer.toSignerInfo((DERObjectIdentifier)contentTypeOID, hash, this.rand, sigProvider, addDefaultAttributes, isCounterSignature));
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for signature.", e);
            }
            catch (SignatureException e) {
                throw new CMSException("error creating signature.", e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", e);
            }
        }
        ASN1Set certificates = null;
        if (this.certs.size() != 0) {
            certificates = CMSUtils.createBerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (this.crls.size() != 0) {
            certrevlist = CMSUtils.createBerSetFromList(this.crls);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, null);
        SignedData sd = new SignedData(new DERSet(digestAlgs), encInfo, certificates, certrevlist, new DERSet(signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, sd);
        return new CMSSignedData((CMSProcessable)null, contentInfo);
    }

    public CMSSignedData generate(CMSProcessable content, boolean encapsulate, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, content, encapsulate, sigProvider);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signer, Provider sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(null, new CMSProcessableByteArray(signer.getSignature()), false, sigProvider).getSignerInfos();
    }

    private class SignerInf {
        PrivateKey key;
        X509Certificate cert;
        String digestOID;
        String encOID;
        CMSAttributeTableGenerator sAttr;
        CMSAttributeTableGenerator unsAttr;
        AttributeTable baseSignedTable;

        SignerInf(PrivateKey key, X509Certificate cert, String digestOID, String encOID) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
        }

        SignerInf(PrivateKey key, X509Certificate cert, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSigneTable) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSigneTable;
        }

        PrivateKey getKey() {
            return this.key;
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        String getDigestAlgOID() {
            return this.digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this.encOID;
        }

        CMSAttributeTableGenerator getSignedAttributes() {
            return this.sAttr;
        }

        CMSAttributeTableGenerator getUnsignedAttributes() {
            return this.unsAttr;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, CMSProcessable content, SecureRandom random, Provider sigProvider, boolean addDefaultAttributes, boolean isCounterSignature) throws IOException, SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            byte[] tmp;
            ASN1Set signedAttr;
            AttributeTable signed;
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), new DERNull());
            AlgorithmIdentifier encAlgId = AtexoCMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID(), null);
            String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
            MessageDigest dig = CMSSignedHelper.INSTANCE.getDigestInstance(digestName, sigProvider);
            byte[] hash = null;
            if (content != null) {
                content.write(new DigOutputStream(dig));
                hash = dig.digest();
                AtexoCMSSignedDataGenerator.this.digests.put(this.digestOID, hash.clone());
            }
            if (addDefaultAttributes) {
                Map parameters = AtexoCMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                signed = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            } else {
                signed = this.baseSignedTable;
            }
            if (isCounterSignature) {
                Hashtable ats = signed.toHashtable();
                ats.remove(CMSAttributes.contentType);
                signed = new AttributeTable(ats);
            }
            if ((signedAttr = AtexoCMSSignedDataGenerator.this.getAttributeSet(signed)) != null) {
                tmp = signedAttr.getEncoded("DER");
            } else {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                content.write(bOut);
                tmp = bOut.toByteArray();
            }
            sig.initSign(this.key, random);
            sig.update(tmp);
            DEROctetString encDigest = new DEROctetString(sig.sign());
            Map parameters = AtexoCMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            parameters.put("encryptedDigest", encDigest.getOctets().clone());
            AttributeTable unsigned = this.unsAttr != null ? this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set unsignedAttr = AtexoCMSSignedDataGenerator.this.getAttributeSet(unsigned);
            X509Certificate cert = this.getCertificate();
            ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getTBSCertificate());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
        }

        SignerInfo toSignerInfo(DERObjectIdentifier contentType, byte[] hash, SecureRandom random, Provider sigProvider, boolean addDefaultAttributes, boolean isCounterSignature) throws IOException, SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            byte[] tmp;
            ASN1Set signedAttr;
            AttributeTable signed;
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), new DERNull());
            AlgorithmIdentifier encAlgId = AtexoCMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID(), null);
            String digestName = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String signatureName = digestName + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Signature sig = CMSSignedHelper.INSTANCE.getSignatureInstance(signatureName, sigProvider);
            if (addDefaultAttributes) {
                Map parameters = AtexoCMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                signed = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            } else {
                signed = this.baseSignedTable;
            }
            if (isCounterSignature) {
                Hashtable ats = signed.toHashtable();
                ats.remove(CMSAttributes.contentType);
                signed = new AttributeTable(ats);
            }
            if ((signedAttr = AtexoCMSSignedDataGenerator.this.getAttributeSet(signed)) != null) {
                tmp = signedAttr.getEncoded("DER");
            } else {
                System.out.println("PROBLEM signedAttr == null");
                tmp = null;
            }
            sig.initSign(this.key, random);
            sig.update(tmp);
            DEROctetString encDigest = new DEROctetString(sig.sign());
            Map parameters = AtexoCMSSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            parameters.put("encryptedDigest", encDigest.getOctets().clone());
            AttributeTable unsigned = this.unsAttr != null ? this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set unsignedAttr = AtexoCMSSignedDataGenerator.this.getAttributeSet(unsigned);
            X509Certificate cert = this.getCertificate();
            ByteArrayInputStream bIn = new ByteArrayInputStream(cert.getTBSCertificate());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance(aIn.readObject());
            IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
            return new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, encDigest, unsignedAttr);
        }
    }

    static class SigOutputStream
    extends OutputStream {
        Signature sig;

        public SigOutputStream(Signature sig) {
            this.sig = sig;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.sig.update(b, off, len);
            }
            catch (SignatureException e) {
                throw new IOException("signature problem: " + e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.sig.update((byte)b);
            }
            catch (SignatureException e) {
                throw new IOException("signature problem: " + e);
            }
        }
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.dig.update(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }
    }
}

