/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.cms.CMSAttributeTableGenerator;

public class DefaultAuthenticatedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultAuthenticatedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultAuthenticatedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map map) {
        Attribute attribute;
        Object object;
        Hashtable hashtable = (Hashtable)this.table.clone();
        if (!hashtable.containsKey(CMSAttributes.contentType)) {
            object = (DERObjectIdentifier)map.get("contentType");
            attribute = new Attribute(CMSAttributes.contentType, new DERSet((DEREncodable)object));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        if (!hashtable.containsKey(CMSAttributes.messageDigest)) {
            object = (byte[])map.get("digest");
            attribute = new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString((byte[])object)));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        return hashtable;
    }

    @Override
    public AttributeTable getAttributes(Map map) {
        return new AttributeTable(this.createStandardAttributeTable(map));
    }
}

