/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.AuthAttributesProvider;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSecureReadable;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.KeyTransRecipient;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientOperator;

public class KeyTransRecipientInformation
extends RecipientInformation {
    private KeyTransRecipientInfo info;

    KeyTransRecipientInformation(KeyTransRecipientInfo keyTransRecipientInfo, AlgorithmIdentifier algorithmIdentifier, CMSSecureReadable cMSSecureReadable, AuthAttributesProvider authAttributesProvider) {
        super(keyTransRecipientInfo.getKeyEncryptionAlgorithm(), algorithmIdentifier, cMSSecureReadable, authAttributesProvider);
        this.info = keyTransRecipientInfo;
        RecipientIdentifier recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier();
        if (recipientIdentifier.isTagged()) {
            ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(aSN1OctetString.getOctets());
        } else {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(recipientIdentifier.getId());
            this.rid = new KeyTransRecipientId(issuerAndSerialNumber.getName(), issuerAndSerialNumber.getSerialNumber().getValue());
        }
    }

    private String getExchangeEncryptionAlgorithmName(DERObjectIdentifier dERObjectIdentifier) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals(dERObjectIdentifier)) {
            return "RSA/ECB/PKCS1Padding";
        }
        return dERObjectIdentifier.getId();
    }

    protected Key getSessionKey(Key key, Provider provider) throws CMSException {
        CMSEnvelopedHelper cMSEnvelopedHelper = CMSEnvelopedHelper.INSTANCE;
        String string = this.getExchangeEncryptionAlgorithmName(this.keyEncAlg.getObjectId());
        try {
            Key key2 = null;
            Cipher cipher = cMSEnvelopedHelper.createAsymmetricCipher(string, provider);
            byte[] byArray = this.info.getEncryptedKey().getOctets();
            String string2 = this.getContentAlgorithmName();
            try {
                cipher.init(4, key);
                key2 = cipher.unwrap(byArray, string2, 3);
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (ProviderException providerException) {
                // empty catch block
            }
            if (key2 == null) {
                cipher.init(2, key);
                key2 = new SecretKeySpec(cipher.doFinal(byArray), string2);
            }
            return key2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CMSException("illegal blocksize in message.", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CMSException("bad padding in message.", badPaddingException);
        }
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    @Override
    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        Key key2 = this.getSessionKey(key, provider);
        return this.getContentFromSessionKey(key2, provider);
    }

    @Override
    protected RecipientOperator getRecipientOperator(Recipient recipient) throws CMSException {
        return ((KeyTransRecipient)recipient).getRecipientOperator(this.keyEncAlg, this.messageAlgorithm, this.info.getEncryptedKey().getOctets());
    }
}

