/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CertSelector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Selector;

public class SignerId
extends X509CertSelector
implements Selector {
    private byte[] subjectKeyId;
    private X500Name issuer;
    private BigInteger serialNumber;

    public SignerId() {
    }

    public SignerId(byte[] byArray) {
        super.setSubjectKeyIdentifier(new DEROctetString(byArray).getDEREncoded());
        this.subjectKeyId = byArray;
    }

    public SignerId(X500Name x500Name, BigInteger bigInteger) {
        this.issuer = x500Name;
        this.serialNumber = bigInteger;
        try {
            this.setIssuer(x500Name.getDEREncoded());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid issuer: " + iOException.getMessage());
        }
        this.setSerialNumber(bigInteger);
    }

    public int hashCode() {
        int n = Arrays.hashCode(this.subjectKeyId);
        if (this.serialNumber != null) {
            n ^= this.serialNumber.hashCode();
        }
        if (this.issuer != null) {
            n ^= this.issuer.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignerId)) {
            return false;
        }
        SignerId signerId = (SignerId)object;
        return Arrays.areEqual(this.subjectKeyId, signerId.subjectKeyId) && this.equalsObj(this.serialNumber, signerId.serialNumber) && this.equalsObj(this.issuer, signerId.issuer);
    }

    private boolean equalsObj(Object object, Object object2) {
        return object != null ? object.equals(object2) : object2 == null;
    }

    @Override
    public boolean match(Object object) {
        if (object instanceof X509CertificateHolder) {
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
            if (this.getSerialNumber() != null) {
                IssuerAndSerialNumber issuerAndSerialNumber = x509CertificateHolder.getIssuerAndSerialNumber();
                return issuerAndSerialNumber.getName().equals(this.issuer) && issuerAndSerialNumber.getSerialNumber().getValue().equals(this.serialNumber);
            }
            if (this.getSubjectKeyIdentifier() != null) {
                X509Extension x509Extension = x509CertificateHolder.getExtension(X509Extension.subjectKeyIdentifier);
                if (x509Extension == null) {
                    SHA1Digest sHA1Digest = new SHA1Digest();
                    byte[] byArray = new byte[sHA1Digest.getDigestSize()];
                    byte[] byArray2 = x509CertificateHolder.getSubjectPublicKeyInfo().getDEREncoded();
                    sHA1Digest.update(byArray2, 0, byArray2.length);
                    sHA1Digest.doFinal(byArray, 0);
                    return Arrays.areEqual(this.subjectKeyId, byArray);
                }
                byte[] byArray = ASN1OctetString.getInstance(x509Extension.getParsedValue()).getOctets();
                return Arrays.areEqual(this.subjectKeyId, byArray);
            }
        } else {
            if (object instanceof byte[]) {
                return Arrays.areEqual(this.subjectKeyId, (byte[])object);
            }
            if (object instanceof SignerInformation) {
                return ((SignerInformation)object).getSID().equals(this);
            }
        }
        return false;
    }
}

