/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.tsp.MessageImprint;
import org.bouncycastle.asn1.tsp.TimeStampReq;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.tsp.TimeStampRequest;

public class TimeStampRequestGenerator {
    private DERObjectIdentifier reqPolicy;
    private DERBoolean certReq;
    private Hashtable extensions = new Hashtable();
    private Vector extOrdering = new Vector();

    public void setReqPolicy(String string) {
        this.reqPolicy = new DERObjectIdentifier(string);
    }

    public void setCertReq(boolean bl) {
        this.certReq = new DERBoolean(bl);
    }

    public void addExtension(String string, boolean bl, ASN1Encodable aSN1Encodable) throws IOException {
        this.addExtension(string, bl, aSN1Encodable.getEncoded());
    }

    public void addExtension(String string, boolean bl, byte[] byArray) {
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        this.extensions.put(dERObjectIdentifier, new X509Extension(bl, (ASN1OctetString)new DEROctetString(byArray)));
        this.extOrdering.addElement(dERObjectIdentifier);
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, ASN1Encodable aSN1Encodable) throws IOException {
        this.addExtension(aSN1ObjectIdentifier, bl, aSN1Encodable.getEncoded());
    }

    public void addExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, byte[] byArray) {
        this.extensions.put(aSN1ObjectIdentifier, new X509Extension(bl, (ASN1OctetString)new DEROctetString(byArray)));
        this.extOrdering.addElement(aSN1ObjectIdentifier);
    }

    public TimeStampRequest generate(String string, byte[] byArray) {
        return this.generate(string, byArray, null);
    }

    public TimeStampRequest generate(String string, byte[] byArray, BigInteger bigInteger) {
        if (string == null) {
            throw new IllegalArgumentException("No digest algorithm specified");
        }
        DERObjectIdentifier dERObjectIdentifier = new DERObjectIdentifier(string);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(dERObjectIdentifier, new DERNull());
        MessageImprint messageImprint = new MessageImprint(algorithmIdentifier, byArray);
        X509Extensions x509Extensions = null;
        if (this.extOrdering.size() != 0) {
            x509Extensions = new X509Extensions(this.extOrdering, this.extensions);
        }
        if (bigInteger != null) {
            return new TimeStampRequest(new TimeStampReq(messageImprint, this.reqPolicy, new DERInteger(bigInteger), this.certReq, x509Extensions));
        }
        return new TimeStampRequest(new TimeStampReq(messageImprint, this.reqPolicy, null, this.certReq, x509Extensions));
    }

    public TimeStampRequest generate(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray, BigInteger bigInteger) {
        return this.generate(aSN1ObjectIdentifier.getId(), byArray, bigInteger);
    }
}

